// 
// scpl.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _scpl_INCLUDED_
#define _scpl_INCLUDED_

/*
	CuŜ̊b`LqĂ܂B
	Cugp鑤͒ڃCN[hȂƂ
	gp鑼̃Cut@CKvɉăCN[h܂B
*/

/* ʒ`B */
#include <stdio.h>
#include <memory.h>
#include "cdiff.h"

/*
	ev[g`}NB
	ev[g̎ɎgpłB
*/
#define TMP template <class T>
#define TMP_(t) template <class t>

/* t@C}NUNICODE */
#define __WFILE__ L##__FILE__

namespace scpl{

	/* GCAX`B */
	typedef unsigned char uchar,byte;
	typedef unsigned short ushort;
	typedef unsigned int uint;
	typedef unsigned long ulong;

	typedef char* str;
	typedef const char* cstr;

	typedef wchar_t wchar;

	typedef wchar_t* wstr;
	typedef const wchar_t* cwstr;

	typedef __int64 i64;
	typedef unsigned __int64 ui64;

	typedef __int64 fpos;

	/* ANSI<->UNICODEnCubh` */
#ifdef _UNICODE
	typedef wchar_t tchar;
	typedef wchar_t* tstr;
	typedef const wchar_t* ctstr;
#define TC(str) L##str
#define __TFILE__ __WFILE__
#else
	typedef char tchar;
	typedef char* tstr;
	typedef const char* ctstr;
#define TC(str) str
#define __TFILE__ __FILE__
#endif
	/* |C^l^ */
#if defined(_WIN64)||defined(_Wp64)||(defined(COMPILER_BCC_581)&&!defined(_M_IX86))
	typedef unsigned __int64 pnum;
#else
	typedef unsigned long pnum;
#endif

} // namespace scpl

/* Z[teB[J֐1 */
#define S_FREE(s) if(s){free(s);s = NULL;}
#define S_RELEASE(s) if(s){(s)->Release();s = NULL;}
#define S_DELETE(s) if(s){delete s;s = NULL;}
#define S_DELETEARY(s) if(s){delete[] s;s = NULL;}
#define S_CLOSEHDL(s) if(s){CloseHandle(s);s = NULL;}
#define S_FREEUSER(s,uf) if(s){uf(s);s = NULL;}

/* Z[teB[J֐2(fXgN^ȂǁAϐNULLɂKvȂ) */
#define _FREE(s) if(s) free(s)
#define _RELEASE(s) if(s) (s)->Release()
#define _DELETE(s) if(s) delete s
#define _DELETEARY(s) if(s) delete[] s
#define _CLOSEHDL(s) if(s) CloseHandle(s)
#define _FREEUSER(s,uf) if(s) uf(s)

/* Z[teB[J֐3(ɂĉKvꍇ) */
#define IF_S_FREE(f,s) if(f){free(s);s = NULL;}
#define IF_S_RELEASE(f,s) if(f){(s)->Release();s = NULL;}
#define IF_S_DELETE(f,s) if(f){delete s;s = NULL;}
#define IF_S_DELETEARY(f,s) if(f){delete[] s;s = NULL;}
#define IF_S_CLOSEHDL(f,s) if(f){CloseHandle(s);s = NULL;}
#define IF_S_FREEUSER(f,s,uf) if(f){uf(s);s = NULL;}

/* Z[teB[J֐4(23ƍ킹) */
#define IF_FREE(f,s) if(f) free(s)
#define IF_RELEASE(f,s) if(f) (s)->Release()
#define IF_DELETE(f,s) if(f) delete s
#define IF_DELETEARY(f,s) if(f) delete[] s
#define IF_CLOSEHDL(f,s) if(f) CloseHandle(s)
#define IF_FREEUSER(f,s,uf) if(f) uf(s)

#endif
