// 
// algorithm.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _algorithm_INCLUDED_
#define _algorithm_INCLUDED_
#include "scpl.h"
#include "CallBack.h"

namespace scpl{

	/*
		IȃASYLqt@CłB
	*/

	namespace alg{

		/*
			f[^݂邩ǂԂ܂B
			data - ׂ郊Xg
			count - Xg̍ڐ
		*/
		TMP bool isOverlap(const T* data,ulong count){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j) return true;
				}
			}
			return false;
		}
		template <class T,ulong count>
		bool isOverlap(const T(&data)[count]){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j) return true;
				}
			}
			return false;
		}
		/*
			w肵ɂēf[^݂邩ǂԂ܂B
			data  - ׂ郊Xg
			count - Xg̍ڐ
			fif   - ֐
		*/
		TMP bool isOverlap(const T* data,ulong count,CallBack2r<bool,const T*,const T*>* fif){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif->call(i,j)) return true;
				}
			}
			return false;
		}
		template <class T,ulong count>
		bool isOverlap(const T(&data)[count],CallBack2r<bool,const T*,const T*>* fif){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif->call(i,j)) return true;
				}
			}
			return false;
		}

		/*
			f[^݂邩ǂԂ܂B
			data - ׂ郊Xg
			count - Xg̍ڐ
			r1,r2 - ݂ƂɕԂ铯f[^ɂȂdatã|C^
		*/
		TMP bool isOverlapEx(const T* data,ulong count,const T** r1,const T** r2){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j){
						*r1 = i;
						*r2 = j;
						return true;
					}
				}
			}
			return false;
		}
		template <class T,ulong count>
		bool isOverlapEx(const T(&data)[count],const T** r1,const T** r2){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j){
						*r1 = i;
						*r2 = j;
						return true;
					}
				}
			}
			return false;
		}

		/*
			w肵ɂēf[^݂邩ǂԂ܂B
			data  - ׂ郊Xg
			count - Xg̍ڐ
			fif   - ֐IuWFNg
			r1,r2 - ݂ƂɕԂ铯f[^ɂȂdatã|C^
		*/
		TMP bool isOverlapEx(const T* data,ulong count,CallBack2r<bool,const T*,const T*>* fif,const T** r1,const T** r2){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif->call(i,j)){
						*r1 = i;
						*r2 = j;
						return true;
					}
				}
			}
			return false;
		}
		template <class T,ulong count>
		bool isOverlapEx(const T(&data)[count],CallBack2r<bool,const T*,const T*>* fif,const T** r1,const T** r2){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif->call(i,j)){
						*r1 = i;
						*r2 = j;
						return true;
					}
				}
			}
			return false;
		}

	} // namespace alg

} // namespace scpl
#endif