// 
// Range.h
// 
// Copyright(C) 2007 Ó
#ifndef _Range_INCLUDED_
#define _Range_INCLUDED_
#include "Exceptions.h"

namespace scpl{

	/*
		w肵͈͂ł̒l̊ǗsNXłB
		̃NXg΁Aől̉̈ʒuɂ邩ȂǁAʒu
		ȒPɎ擾邱Ƃł܂B
		܂Aw肵͈͊Oɒlݒ肷邱ƂłȂ悤ɂĂ邽߁A
		yɐi󋵂ȂǂǗ邱Ƃł܂B

		ev[gF
		V - őlEŏlƌݒľ^B
		X - ZɎgp^B V 葽\ł signed ^gp邱ƂɂA
		    I[o[t[EA_[t[}邱Ƃł܂B

		ӁF
		̃NX̓ev[g X ɂăI[o[t[EA_[t[ɑΉ
		Ă邽߁Aw肵ȂƁA҂ʂɂȂȂꍇ܂B
		̎AI[o[t[EA_[t[́Aȉ̊֐ɂĔꍇ܂B
		operator+=
		operator-=
		plus()
		minus()
	*/
	template<class V,class X=int>
	class Range{
		typedef Range<V> self;
	public:
		Range():_Min(0),_Max(100),_Val(0){}
		/*
			͈͂ݒ肵č쐬܂B
			͈͂sȏꍇ͗O܂B
		*/
		Range(V min,V max)throw(InvalidParamExc):_Min(min),_Max(max),_Val(min){
			if(min > max) throw InvalidParamExc(1);
		}
		/*
			͈͂ƌݒlݒ肵č쐬܂B
			͈͋yьݒlsȏꍇ͗O܂B
		*/
		Range(V min,V max,V val)throw(InvalidParamExc):_Min(min),_Max(max),_Val(val){
			if(min > max) throw InvalidParamExc(1);
			if((val<min)||(max<val)) throw InvalidParamExc(3);
		}

		/* ݒlCNg܂B */
		self& operator++(){inc();return *this;}
		self& operator++(int){inc();return *this;}
		void inc(){_Val += static_cast<byte>(_Val<_Max);}
		/* ݒlfNg܂B */
		self& operator--(){dec();return *this;}
		self& operator--(int){dec();return *this;}
		void dec(){_Val -= static_cast<byte>(_Min<_Val);}

		/* ݒl𑝉܂B */
		self& operator+=(V v){plus(v);return *this;}
		void plus(V v){
			X val = static_cast<X>(_Val)+static_cast<X>(v);
			val = (val<static_cast<X>(_Min))?static_cast<X>(_Min):val;
			_Val = static_cast<V>((static_cast<X>(_Max)<val)?static_cast<X>(_Max):val);
		}
		/* ݒl܂B */
		self& operator-=(V v){minus(v);return *this;}
		void minus(V v){
			X val = static_cast<X>(_Val)-static_cast<X>(v);
			val = (val<static_cast<X>(_Min))?static_cast<X>(_Min):val;
			_Val = static_cast<V>((static_cast<X>(_Max)<val)?static_cast<X>(_Max):val);
		}

		/* ݒlԂ܂B */
		operator V()const{return _Val;}

		/* lőlɂ邩ǂԂ܂B */
		bool isMax()const{return (_Val == _Max);}
		/* lŏlɂ邩ǂԂ܂B */
		bool isMin()const{return (_Val == _Min);}
		/* lŒԂɂ邩ǂԂ܂B */
		bool isFixed()const{return (_Min == _Max);}

		/* ݒlԂ܂B */
		V getVal()const{return _Val;}
		/* őlԂ܂B */
		V getMin()const{return _Min;}
		/* ŏlԂ܂B */
		V getMax()const{return _Max;}

		/*
			ݒlݒ肵܂B
			ݒ肵lŏlȏőlȉŖꍇ false Ԃ܂B
		*/
		bool setVal(V v){
			if((v < _Min)||(_Max < v)) return false;
			_Val = v;
			return true;
		}
		/*
			őlݒ肵܂B
			ݒ肵lݒl𒴂ꍇ false Ԃ܂B
		*/
		bool setMin(V v){
			if(_Val < v) return false;
			_Min = v;
			return true;
		}
		/*
			ŏlݒ肵܂B
			ݒ肵lݒlꍇ false Ԃ܂B
		*/
		bool setMax(V v){
			if(v < _Val) return false;
			_Max = v;
			return true;
		}
		/*
			͈͂ݒ肵č쐬܂B
			͈͂sȏꍇ͗O܂B
		*/
		void set(V min,V max)throw(InvalidParamExc){
			if((min > max)||(min > _Val)) throw InvalidParamExc(1);
			if(max < _Val) throw InvalidParamExc(2);
			_Min = min;
			_Max = max;
		}
		/*
			͈͂ƌݒlݒ肵č쐬܂B
			͈͋yьݒlsȏꍇ͗O܂B
		*/
		void set(V min,V max,V val)throw(InvalidParamExc){
			if(min > max) throw InvalidParamExc(1);
			if((val<min)||(max<val)) throw InvalidParamExc(3);
			_Min = min;
			_Max = max;
			_Val = val;
		}

		/* ݒli(int)ŕԂ܂B */
		int getProgressParInt()const{return (_Min==_Max)?100:((_Min==_Val)?0:static_cast<int>((_Val - _Min) / static_cast<double>(_Max - _Min) * 100));}
		/* ݒli(double)ŕԂ܂B */
		double getProgressParDouble()const{return (_Min==_Max)?100:((_Min==_Val)?0:((_Val - _Min) / static_cast<double>(_Max - _Min)));}
		/* ݒli(float)ŕԂ܂B */
		float getProgressParFloat()const{return (_Min==_Max)?100:((_Min==_Val)?0:((_Val - _Min) / static_cast<float>(_Max - _Min)));}

		/* ݒlci(int)ŕԂ܂B */
		int getRProgressParInt()const{return 100 - getProgressParInt();}
		/* ݒlci(double)ŕԂ܂B */
		double getRProgressParDouble()const{return 1.0 - getProgressParDouble();}
		/* ݒlci(float)ŕԂ܂B */
		float getRProgressParFloat()const{return 1.0f - getProgressParFloat();}

		/* ݒlilŕԂ܂B */
		V getProgress()const{return _Val - _Min;}
		/* ݒlcilŕԂ܂B */
		V getRProgress()const{return _Max - _Val;}

	private:
		V _Min,_Max,_Val;
	};

} // namespace scpl
#endif
