// 
// Function.h
// 
// Copyright(C) 2006 Ó
#ifndef _Function_INCLUDED_
#define _Function_INCLUDED_
#include "scpl.h"

namespace scpl{

	/*
		rs֐IuWFNgQłB

		ev[g̐
		A - rsӂ̌^B
		B - rsEӂ̌^BȗAƓɂȂB
	*/

	/*
		s̊֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncIf{

		virtual bool operator()(A& a,B& b)const=0;

	};

	/*
		vs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncEqual : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A == B;}

	};

	/*
		svs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncNoEqual : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A != B;}

	};

	/*
		"A < B"̏s֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncAbove : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A < B;}

	};

	/*
		"A > B"̏s֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncBelow : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A > B;}

	};

	/*
		"A <= B"̏s֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncEqualAbove : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A <= B;}

	};

	/*
		"A >= B"̏s֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncEqualBelow : public FuncIf<A,B>{

		virtual bool operator()(A& a,B& b)const{return A >= B;}

	};

	/// 萔r

	/*
		萔rs̊֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstIf{
		const B& _T;
		FuncConstIf(const B& t):_T(t){}

		virtual bool operator()(A& a)const=0;

	};

	/*
		萔vrs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstEqual : public FuncConstIf<A,B>{

		FuncConstEqual(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A == _T;}

	};

	/*
		萔svrs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstNoEqual : public FuncConstIf<A,B>{

		FuncConstNoEqual(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A != _T;}

	};

	/*
		"A < B"̒萔rs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstAbove : public FuncConstIf<A,B>{

		FuncConstAbove(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A < _T;}

	};

	/*
		"A > B"̒萔rs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstBelow : public FuncConstIf<A,B>{

		FuncConstBelow(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A > _T;}

	};

	/*
		"A <= B"̒萔rs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstEqualAbove : public FuncConstIf<A,B>{

		FuncConstEqualAbove(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A <= _T;}

	};

	/*
		"A >= B"̒萔rs֐IuWFNgB
	*/
	template <class A,class B = A> struct FuncConstEqualBelow : public FuncConstIf<A,B>{

		FuncConstEqualBelow(const B& t):FuncConstIf(t){}

		virtual bool operator()(A& a)const{return A >= _T;}

	};

} // namespace scpl
#endif