#include "stdafx.h"
#include "..\scpl/Color.h"

using namespace scpl;
using namespace scpl::color;

void test_color(){
	ulong red=0xffff0000,_green=0x0000ff00,blue=0xff0000ff;
	ulong a=0xc0c08080,b=0x8080c0c0,c=0x40404040;
	uchar p0=0x00,p25=0x40,p50=0x80,p75=0xc0,p99=0xff;
	
	SUT_ASSERT_EQUALS(Hex,toARGB(p99,p99,p0,p0),red);
	SUT_ASSERT_EQUALS(Hex,toRGB(p0,p0,p99),blue);
	SUT_ASSERT_EQUALS(Hex,toARGB(p0,p0,p99,p0),_green);
	SUT_ASSERT_EQUALS(Hex,center(p0,p50),p25);
	SUT_ASSERT_EQUALS(Hex,center(p0,p75),0x60);
	SUT_ASSERT_EQUALS(Hex,centerARGB(a,b),0xa0a0a0a0);
	SUT_ASSERT_EQUALS(Hex,centerARGB(a,c),0x80806060);
	SUT_ASSERT_EQUALS(Hex,centerARGB(b,c),0x60608080);
	SUT_ASSERT_EQUALS(Hex,centerRGB(a,b,p0 ),0x00a0a0a0);
	SUT_ASSERT_EQUALS(Hex,centerRGB(a,c,p50),0x80806060);
	SUT_ASSERT_EQUALS(Hex,centerRGB(b,c,p99),0xff608080);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(red),0x0000ffff);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(_green),0xffff00ff);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(b),0x7f7f3f3f);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(c),0xbfbfbfbf);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(a),0xc03f7f7f);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(blue),0xffffff00);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(_green),0x00ff00ff);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(c),0x40bfbfbf);
}