#include "stdafx.h"
#include "../scpl/algorithm.h"
#include "../scpl/utility.h"

using namespace scpl;
using namespace scpl::alg;

struct fif_cls{
	bool func_ok(cstr,cstr){return true;}
	bool func_ng(cstr,cstr){return false;}
};

void test_algorithm(){
	fif_cls cls;
	CallBack2r<bool,cstr,cstr>* b_ok = createCallBack<fif_cls>(&fif_cls::func_ok,&cls);
	CallBack2r<bool,cstr,cstr>* b_ng = createCallBack<fif_cls>(&fif_cls::func_ng,&cls);
	{
		 // swap
		int a=0,b=100,c=200;
		swap(a,b);
		SUT_ASSERT_EQUALS(Int,a,100);
		SUT_ASSERT_EQUALS(Int,b,  0);
		swap(a,c);
		SUT_ASSERT_EQUALS(Int,a,200);
		SUT_ASSERT_EQUALS(Int,c,100);
		swap(a,b);
		SUT_ASSERT_EQUALS(Int,a,  0);
		SUT_ASSERT_EQUALS(Int,b,200);
	}
	{
		 // center
		short a=-200,b=0,c=400;
		SUT_ASSERT(Int,center(a,a)==-200);
		SUT_ASSERT(Int,center(a,b)==-100);
		SUT_ASSERT(Int,center(a,c)== 100);
		SUT_ASSERT(Int,center(b,a)==-100);
		SUT_ASSERT(Int,center(b,b)==   0);
		SUT_ASSERT(Int,center(b,c)== 200);
		SUT_ASSERT(Int,center(c,a)== 100);
		SUT_ASSERT(Int,center(c,b)== 200);
		SUT_ASSERT(Int,center(c,c)== 400);
	}
	{
		 // isOverlap(1)
		char a[]="qawsedfrtgyhujikol@,";
		char b[]="wzexrctvybuneimo,asd";
		char c[]="zxcv2b34n5m67,89^.--";
		SUT_ASSERT(Int,!isOverlap(a,20));
		SUT_ASSERT(Int, isOverlap(b,20));
		SUT_ASSERT(Int, isOverlap(c,20));

		 // isOverlap(2)
		SUT_ASSERT(Int,isOverlap(a,20,b_ok));
		SUT_ASSERT(Int,isOverlap(b,20,b_ok));
		SUT_ASSERT(Int,isOverlap(c,20,b_ok));
		 // isOverlap(3)
		SUT_ASSERT(Int,!isOverlap(a,20,b_ng));
		SUT_ASSERT(Int,!isOverlap(b,20,b_ng));
		SUT_ASSERT(Int,!isOverlap(c,20,b_ng));
	}
	{
		 // isOverlapEx(1)
		char a[]="qawsedfrtgyhujikol@,";
		char b[]="wzexrctvybuneimo,asd";
		char c[]="zxcv2b34n5m67,89^.--";
		const char *r1=NULL,*r2=NULL;
		SUT_ASSERT(Int,!isOverlapEx(a,20,&r1,&r2));
		SUT_ASSERT(Int, isOverlapEx(b,20,&r1,&r2));
		SUT_ASSERT_EQUALS(Int,*r1,*r2);
		SUT_ASSERT_EQUALS(Int,_I(r1),_I(b+2));
		SUT_ASSERT_EQUALS(Int,_I(r2),_I(b+12));
		SUT_ASSERT(Int, isOverlapEx(c,20,&r1,&r2));
		SUT_ASSERT_EQUALS(Int,*r1,*r2);
		SUT_ASSERT_EQUALS(Int,_I(r1),_I(c+18));
		SUT_ASSERT_EQUALS(Int,_I(r2),_I(c+19));

		 // isOverlapEx(2)
		SUT_ASSERT(Int,isOverlapEx(a,20,b_ok,&r1,&r2));
		SUT_ASSERT_EQUALS(Int,_I(r1),_I(a));
		SUT_ASSERT_EQUALS(Int,_I(r2),_I(a+1));
		SUT_ASSERT(Int,isOverlapEx(b,20,b_ok,&r1,&r2));
		SUT_ASSERT_EQUALS(Int,_I(r1),_I(b));
		SUT_ASSERT_EQUALS(Int,_I(r2),_I(b+1));
		SUT_ASSERT(Int,isOverlapEx(c,20,b_ok,&r1,&r2));
		SUT_ASSERT_EQUALS(Int,_I(r1),_I(c));
		SUT_ASSERT_EQUALS(Int,_I(r2),_I(c+1));
		 // isOverlapEx(3)
		SUT_ASSERT(Int,!isOverlapEx(a,20,b_ng,&r1,&r2));
		SUT_ASSERT(Int,!isOverlapEx(b,20,b_ng,&r1,&r2));
		SUT_ASSERT(Int,!isOverlapEx(c,20,b_ng,&r1,&r2));
	}
}