#include "stdafx.h"
#include "..\scpl/File.h"
#include <string.h>

using namespace scpl;
void test_File(){
	{
		// 0 //									// RW+B --
		FileReader f01("t01");					// 1000  1
		FileWriter f02("t02");					// 0100  2
		FileWriter f03("t03",false,true);		// 1100  3
		FileBoth   f04("t04",true);				// 1010  5
		FileBoth   f05("t05");					// 0110  6
		FileBoth   f06("t06",false,false,true);	// 1110  7
		FileReader f07("t07",true);				// 1001  9
		FileWriter f08("t08",true);				// 0101 10
		FileWriter f09("t09",true,true);		// 1101 11
		FileBoth   f10("t10",true,true);		// 1011 13
		FileBoth   f11("t11",false,true);		// 0111 14
		FileBoth   f12("t12",false,true,true);	// 1111 15
	}
	{
		// 1 //
		FileWriter f("test.txt");
		f.putChar('@');
		f.putStr("test string.");
		f.putStr("I\n");
		f.putWChar(L'@');
		f.putWStr(L"test string.");
		f.putWStr(L"I\n");
		f.flush();
		SUT_ASSERT(Int, f.opened());
		SUT_ASSERT(Int,!f.eof());
		SUT_ASSERT(Int,!f.error());
		SUT_ASSERT_EQUALS(Int,_U(f.getpos()),32);
	}
	{
		// 2 //
		FileReader f("test.txt");
		char buf[64];
		char i = f.getChar();
		SUT_ASSERT_EQUALS(Int,i,'@');
		f.getStr<64>(buf);
#ifndef __BORLANDC__
		SUT_ASSERT_EQUALS(Int,_stricmp(buf,"test string.I\n"),0);
#else
		SUT_ASSERT_EQUALS(Int,stricmp(buf,"test string.I\n"),0);
#endif
		SUT_ASSERT(Int,!f.eof());
		SUT_ASSERT(Int,!f.error());
		size_t s = f.read(buf,1,20);
		SUT_ASSERT_EQUALS(Int,_U(s),15);
		SUT_ASSERT(Int,f.eof());
		SUT_ASSERT(Int,!f.error());
		SUT_ASSERT_EQUALS(Hex,buf[0],'@');
		SUT_ASSERT_EQUALS(Hex,buf[1],'t');
		SUT_ASSERT_EQUALS(Int,_U(f.getpos()),32);
		f.close();
		SUT_ASSERT(Int,!f.eof());
		SUT_ASSERT(Int,!f.error());
		SUT_ASSERT(Int,!f.opened());
	}
}