// 
// File.cpp
// 
// Copylight(C) 2007 Ó

#include "stdafx.h"
#include "../scpl/File.h"
#include "../scpl/frag.h"
namespace scpl{

/* File */

	void File::gen_fmode(ulong mode,char(&rmode)[4]){
		bool plus = isFragOnBit(mode,2);
		bool bin = isFragOnBit(mode,3);
		byte pos=1;
		switch(mode&3){
			case 1:rmode[0] = 'r';break;
			case 2:rmode[0] = 'w';break;
			case 3:rmode[0] = 'a';break;
#ifdef _DEBUG
			default: throw IOExc(IOExc::UNKNOW);
#endif
		}
		if(plus) rmode[pos++] = '+';
		rmode[pos++] = bin?'b':'t';
		rmode[pos] = '\0';
	}
	void File::gen_fmode(ulong mode,wchar_t(&rmode)[4]){
		bool plus = isFragOnBit(mode,2);
		bool bin = isFragOnBit(mode,3);
		byte pos=1;
		switch(mode&3){
			case 1:rmode[0] = L'r';break;
			case 2:rmode[0] = L'w';break;
			case 3:rmode[0] = L'a';break;
#ifdef _DEBUG
			default: throw IOExc(IOExc::UNKNOW);
#endif
		}
		if(plus) rmode[pos++] = L'+';
		rmode[pos++] = bin?L'b':L't';
		rmode[pos] = L'\0';
	}

	void File::flush()throw(IOExc){
		if(fflush(_Fp) == EOF) throw IOExc((!_Fp)?IOExc::NOT_OPEN:IOExc::FLUSH);
	}

/* AFileReader */

	size_t AFileReader::read(void* buf,size_t size,size_t count)throw(InvalidParamExc,IOExc){
		int i = !buf?1:(!size?2:(!count?3:0));
		if(i!=0) throw InvalidParamExc(i);
		size_t s = fread(buf,size,count,_Fp);
		if(s == 0) throw IOExc(error()?IOExc::READ:IOExc::ENDOFSEEK);
		return s;
	}

	char AFileReader::getChar()throw(IOExc){
		int i = fgetc(_Fp);
		if(i == EOF) throw IOExc(error()?IOExc::READ:IOExc::ENDOFSEEK);
		return static_cast<char>(i);
	}
	wchar_t AFileReader::getWChar()throw(IOExc){
		wchar_t i = fgetwc(_Fp);
		if(i == WEOF) throw IOExc(error()?IOExc::READ:IOExc::ENDOFSEEK);
		return i;
	}
	void AFileReader::getStr(str buf,size_t size)throw(IOExc){
		if(!fgets(buf,static_cast<int>(size),_Fp)){
			throw IOExc(error()?IOExc::READ:IOExc::ENDOFSEEK);
		}
	}
	void AFileReader::getWStr(wstr buf,size_t size)throw(IOExc){
		if(!fgetws(buf,static_cast<int>(size),_Fp)){
			throw IOExc(error()?IOExc::READ:IOExc::ENDOFSEEK);
		}
	}
	void AFileReader::getnStr(str buf,size_t size)throw(IOExc){
		if(!fgets(buf,static_cast<int>(size),_Fp)&&error()) throw IOExc(IOExc::READ);
	}
	void AFileReader::getnWStr(wstr buf,size_t size)throw(IOExc){
		if(!fgetws(buf,static_cast<int>(size),_Fp)&&error()) throw IOExc(IOExc::READ);
	}

/* AFileWriter */

	size_t AFileWriter::write(const void* buf,size_t size,size_t count)throw(InvalidParamExc,IOExc){
		int i = !buf?1:(!size?2:(!count?3:0));
		if(i!=0) throw InvalidParamExc(i);
		size_t s = fwrite(buf,size,count,_Fp);
		if(s == 0) throw IOExc(IOExc::WRITE);
		return s;
	}
	void AFileWriter::putChar(char c)throw(IOExc){
		int i = fputc(c,_Fp);
		if(i == EOF) throw IOExc(IOExc::WRITE);
	}
	void AFileWriter::putWChar(wchar_t c)throw(IOExc){
		wchar_t i = fputwc(c,_Fp);
		if(i == WEOF) throw IOExc(IOExc::WRITE);
	}
	void AFileWriter::putStr(cstr buf)throw(IOExc){
		int i = fputs(buf,_Fp);
		if(i == EOF) throw IOExc(IOExc::WRITE);
	}
	void AFileWriter::putWStr(cwstr buf)throw(IOExc){
		int i = fputws(buf,_Fp);
		if(i == EOF) throw IOExc(IOExc::WRITE);
	}

/* FileReader */

	void FileReader::open(cstr fname,bool binary,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(_Fp) throw IOExc(IOExc::OPENED);
		char mode[4];
		gen_fmode(binary?5:1,mode);
		_Fp = _fsopen(fname,mode,shfrag);
		if(!_Fp) throw IOExc(IOExc::NO_OPEN);
		_IsBinary = binary;
	}
	void FileReader::open(cwstr fname,bool binary,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(_Fp) throw IOExc(IOExc::OPENED);
		wchar_t mode[4];
		gen_fmode(binary?5:1,mode);
		_Fp = _wfsopen(fname,mode,shfrag);
		if(!_Fp) throw IOExc(IOExc::NO_OPEN);
		_IsBinary = binary;
	}

/* FileWriter */

	void FileWriter::open(cstr fname,bool binary,bool add,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(_Fp) throw IOExc(IOExc::OPENED);
		char mode[4];
		gen_fmode((add?3:2)|(binary?4:0),mode);
		_Fp = _fsopen(fname,mode,shfrag);
		if(!_Fp) throw IOExc(IOExc::NO_OPEN);
		_IsBinary = binary;
	}
	void FileWriter::open(cwstr fname,bool binary,bool add,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(_Fp) throw IOExc(IOExc::OPENED);
		wchar_t mode[4];
		gen_fmode((add?3:2)|(binary?4:0),mode);
		_Fp = _wfsopen(fname,mode,shfrag);
		if(!_Fp) throw IOExc(IOExc::NO_OPEN);
		_IsBinary = binary;
	}

/* FileBoth */

	void FileBoth::open(cstr fname,bool exist,bool binary,bool add,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(AFileReader::_Fp) throw IOExc(IOExc::OPENED);
		char mode[4];
		AFileReader::gen_fmode(4|(add?3:(exist?1:2))|(binary?4:0),mode);
		AFileReader::_Fp = _fsopen(fname,mode,shfrag);
		if(!AFileReader::_Fp) throw IOExc(IOExc::NO_OPEN);
		AFileReader::_IsBinary = binary;
	}
	void FileBoth::open(cwstr fname,bool exist,bool binary,bool add,SHAREFRAG shfrag)throw(InvalidParamExc,IOExc){
		if(!fname) throw InvalidParamExc(1);
		if(AFileReader::_Fp) throw IOExc(IOExc::OPENED);
		wchar_t mode[4];
		AFileReader::gen_fmode(4|(add?3:(exist?1:2))|(binary?4:0),mode);
		AFileReader::_Fp = _wfsopen(fname,mode,shfrag);
		if(!AFileReader::_Fp) throw IOExc(IOExc::NO_OPEN);
		AFileReader::_IsBinary = binary;
	}

} // namespace scpl
