// 
// AString.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/AString.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#if !defined(_MSC_VER) && !defined(__BORLANDC__)
#define ultoa _ultoa
#endif

namespace scpl{

	inline ulong _cap(ulong x){return (x==0)?0:x-1;}
#define _CAP _cap(capacity())
	char& AString::at(ulong i)const throw(InvalidParamExc,InvalidCallExc){
		if(i < _UseCount) return *(_Text.get() + i);
		if(empty()) throw InvalidCallExc();
		throw InvalidParamExc(1);
	}
	AString& AString::insertChar(char c,ulong index)throw(InvalidParamExc,OutOfMemExc){
		if(index > _UseCount) throw InvalidParamExc(1);
		if(_CAP == _UseCount){
			_Text.aResize(_UseCount + 2,true);
		}
		str pos = _Text.get() + index;
		if(index != _UseCount){
			memmove(pos + 1,pos,(_UseCount - index) * sizeof(char));
		}
		*pos = c;
		++_UseCount;
		return *this;
	}
	bool AString::outputChar(char c){
		bool suc = true;
		try{
			if(_CAP == _UseCount){
				_Text.aResize(_UseCount + 2,true);
			}
			*(_Text.get() + _UseCount++) = c;
		}
		catch(...){suc = false;}
		return suc;
	}
	AString& AString::insertStr(cstr text,long count,ulong index)throw(InvalidParamExc,OutOfMemExc){
		if(text && (count != 0)){
			if(index > _UseCount) throw InvalidParamExc(3);
			if(count < 0) count = static_cast<long>(strlen(text));
			long cp = _UseCount+count+1;
			if(static_cast<ulong>(cp) > _CAP) _Text.aResize(cp,true);
			str pos = _Text.get() + index;
			if(index != _UseCount){
				memmove(pos + count,pos,(_UseCount - index) * sizeof(char));
			}
			memcpy(pos,text,count * sizeof(char));
			_UseCount += count;
			*(_Text.get()+_UseCount) = 0;
		}
		return *this;
	}
	bool AString::outputStr(cstr text){
		bool suc = true;
		try{
			ulong s = static_cast<ulong>(strlen(text));
			if(0 < s){
				long cp = _CAP - _UseCount - s;
				if(cp < 0) _Text.rResize(-cp + 1,true);
				memcpy(_Text.get() + _UseCount,text,s * sizeof(char));
				_UseCount += s;
			}
			else suc = false;
		}
		catch(...){suc = false;}
		return suc;
	}

	AString& AString::insertNum(long l,ulong index,long radix)throw(InvalidParamExc,OutOfMemExc){
		char buf[32];
		if((radix < 2)||(36 < radix)) throw InvalidParamExc(3);
		memset(buf,0,32 * sizeof(char));
		ltoa(l,buf,radix);
		return insertStr(buf,-1,index);
	}
	bool AString::outputNum(long l,long radix){
		try{lastInNum(l,radix);}
		catch(...){return false;}
		return true;
	}
	AString& AString::insertUNum(ulong l,ulong index,long radix)throw(InvalidParamExc,OutOfMemExc){
		char buf[32];
		if((radix < 2)||(36 < radix)) throw InvalidParamExc(3);
		memset(buf,0,32 * sizeof(char));
		ultoa(l,buf,radix);
		return insertStr(buf,-1,index);
	}
	bool AString::outputUNum(ulong l,long radix){
		try{lastInUNum(l,radix);}
		catch(...){return false;}
		return true;
	}
	bool AString::output(const self& text){
		bool suc = true;
		try{
			if(0 < text.count()){
				long cp = _CAP - _UseCount - text.count();
				if(cp < 0) _Text.rResize(-cp + 1,true);
				memcpy(_Text.get() + _UseCount,text,text.count() * sizeof(char));
				_UseCount += text.count();
			}
			else suc = false;
		}
		catch(...){suc = false;}
		return suc;
	}
	void AString::removeAt(ulong index)throw(InvalidParamExc,InvalidCallExc){
		if(index >= _UseCount) throw InvalidParamExc(1);
		if(_UseCount == 0) throw InvalidCallExc();
		str pos = _Text.get() + index;
		if(index != --_UseCount){
			memmove(pos,pos + 1,(_UseCount - index) * sizeof(char));
		}
		*(_Text.get() + _UseCount) = 0;
	}
	void AString::erage(ulong indexL,ulong indexR)throw(InvalidParamExc,InvalidCallExc){
		if(indexL >= indexR) throw InvalidParamExc(1);
		if(_UseCount == 0) throw InvalidCallExc();
		if(indexR > _UseCount) throw InvalidParamExc(2);
		if(indexR != _UseCount){
			memmove(_Text.get() + indexL,_Text + indexR,(_UseCount - indexR) * sizeof(char));
		}
		memset(_Text.get() + (_UseCount - indexR + indexL),0,(indexR - indexL) * sizeof(char));
		_UseCount -= (indexR - indexL);
	}
	void AString::clear(bool noClearCapacity){
		_UseCount = 0;
		if(!noClearCapacity) _Text.clear();
		else if(_Text) *_Text.get() = 0;
	}
	void AString::copy(cstr s,long count)throw(OutOfMemExc){
		if(s && (count != 0)){
			if(count < 0) count = static_cast<long>(strlen(s));
			if(static_cast<ulong>(count+1) > _CAP){
				_Text.aResize(count+1,true);
			}
			else *(_Text.get()+count) = 0;
			memcpy(_Text.get(),s,count*sizeof(char));
			_UseCount = count;
		}
		else clear(false);
	}
	bool AString::equals(cstr s)const{return (strcmp(_Text,s) == 0);}
	long AString::find(char c)const{
		cstr a = strchr(_Text,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	long AString::find(cstr c)const{
		cstr a = strstr(_Text,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	void AString::toLower(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<char>(tolower(*(_Text + i)));
		}
	}
	void AString::toUpper(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<char>(toupper(*(_Text + i)));
		}
	}

	AString AString::strcat(cstr a,cstr b)throw(OutOfMemExc){
		size_t as = strlen(a),bs = strlen(b);
		AString string(static_cast<ulong>(as+bs+1));
		string = a;
		string += b;
		return AString(string._Text,string._UseCount);
	}

	bool operator==(const AString& l,const AString& r){return l.equals(r);}
	bool operator==(cstr l,const AString& r){return r.equals(l);}
	bool operator==(const AString& l,cstr r){return l.equals(r);}
	bool operator!=(const AString& l,const AString& r){return !l.equals(r);}
	bool operator!=(cstr l,const AString& r){return !r.equals(l);}
	bool operator!=(const AString& l,cstr r){return !l.equals(r);}

}
