// 
// managed_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _managed_ptr_INCLUDED_
#define _managed_ptr_INCLUDED_
#ifndef __BORLANDC__
#include <typeinfo>
#else
#include <typeinfo.h>
#endif
#include "Exceptions.h"

namespace scpl{

	/*
		̃t@Cɂmanaged_ptrƁAmanaged_aryNX`Ă܂B
		̃NX́Asmart_ptrsmart_aryƓlɎQƃJEgA
		QƂĂSẴ|C^NXdeleteȂA|C^
		J܂B̃NX́Asmartn|C^NX̌_łA
		Ƀ|C^NXɊ܂܂|C^ʂ̃|C^NXɊ܂܂Ƃ
		Ă܂B܂ALXg\łB
		ۂ̏ł́A|C^XgŊǗ̂ŁAsmartn|C^NX
		|C^^֐ŏdȂ\܂B

		̃NXgpꍇAR[hƂ킩܂Af[^ɃANZX
		鉉Zqgpꍇ̓`FbNs܂ixׁ̌̈jB
		`FbNĂقꍇ̓o֐gpĂB

		W̉łdeleteydelete[]g܂A
		L̃}N֐gp΁Ǎ^̉sƂł܂B
		zۗLAǗꍇmanaged_aryNXgpĂB

		ӁF
		managed_ptr NX̃oϐꕔ̓֐ public ƂȂĂ܂
		Ãoϐ֐ɒڃANZXȂłB
		iprivateɂƃG[ɂȂj
	*/

/*
	[U[`̉s}N֐(managed_ptrNX̂)B
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ p łB
*/
#define managed_delete(type) template<> void scpl::managed_ptr<type>::delptr(type* p)

	/* ̖OԂ́Â߂Ɏgp܂B */
	namespace manage_sys{
		class manage_data;
		extern manage_data* md;

		class manage_data{
			static manage_data* md_is_p(const void* p,bool* in){
				for(manage_data* i = md->next;i!=md;i=i->next){
					if(i->ptr <= p){
						*in = (i->ptr == p);
						return i;
					}
				}
				return NULL;
			}
			static manage_data* md_is_m(const void* p,bool* in){
				for(manage_data* i = md->prev;i!=md;i=i->prev){
					if(i->ptr >= p){
						*in = (i->ptr == p);
						return i;
					}
				}
				return NULL;
			}

		public:
			TMP manage_data(T* p):refcount(1),ptr(p){
				if(md){
					prev = md->prev;
					next = md;
					md->prev->next = this;
					md->prev = this;
//					md = this;
				}
				else next = prev = md = this;
			}
			~manage_data(){
				if(md == this){
					if(md->next != md){
						md = next;
						prev->next = next;
						next->prev = prev;
					}
					else{
						md = NULL;
					}
				}
				else{
					prev->next = next;
					next->prev = prev;
				}
			}
			void* get()const{return ptr;}
			ulong count()const{return refcount;}
			void inc(){
				if(refcount) ++refcount;
			}
			ulong dec(){return --refcount;}

			static manage_data* md_is(const void* p,bool* in){
				*in = false;
				if(!md) return NULL;
				manage_data* i = md;
				do{
					if(i->ptr == p){*in = true;return i;}
					i = i->prev;
				}while(i!=md);
				return md->prev;
			}
		private:
			long refcount;
			void* ptr;
			manage_data* next;
			manage_data* prev;

		};
	}

	TMP class managed_ptr{
	public:
		typedef T*				ptr;
		typedef T&				ind;
		typedef const T*		cptr;
		typedef const T&		cind;
		typedef managed_ptr<T>	self;

	private:
		void delptr(T* p){delete p;}
		void dec_del(){
			if(_pm&&(_pm->dec() == 0)){
				delptr(reinterpret_cast<ptr>(_pm->get()));
				delete _pm;
			}
		}

	public:
		/* cast֐ŎgpB(֐) */
		template<class From>
		managed_ptr(manage_sys::manage_data* pos,From* p)throw(std::bad_cast):_pm(pos){
			if(pos){
				_p = dynamic_cast<ptr>(p);
				if(!_p) throw std::bad_cast();
				pos->inc();
			}
			else _p = NULL;
		}

		/* Rs[RXgN^B */
		managed_ptr(const managed_ptr& p):_pm(p._pm),_p(p._p){
			if(p._pm) _pm->inc();
		}
		template<class From>
		managed_ptr(const managed_ptr<From>& p):_pm(p._pm),_p(p._p){
			if(p._pm) _pm->inc();
		}

		/* NULL ۗL܂B */
		managed_ptr():_pm(NULL){}
		/* |C^ۗL܂B */
		template<class From>
		managed_ptr(From* p)throw(OutOfMemExc):_pm(NULL),_p(p){
			if(p){
				bool in;
				_pm = manage_sys::manage_data::md_is(p,&in);
				if(!in) _pm = checkNull(new manage_sys::manage_data(p));
				else _pm->inc();
			}
		}

		~managed_ptr(){dec_del();}

		/* |C^Ԃ܂B */
		operator ptr(){return _p;}
		operator cptr()const{return _p;}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _pm==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == _p;}
		bool operator==(const self& p)const{return _pm == p._pm;}
		bool operator!=(cptr p)const{return p != _p;}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/* w肵|C^NX܂B */
		self& operator=(const self& p){set(p);return *this;}
		template <class From>
		void set(const managed_ptr<From>& p){
			dec_del();
			_pm = p._pm;
			_p = p._p;
			if(p._pm) _pm->inc();
		}

		/* ̂QƂ܂B */
		ind operator*()const{return *_p;}
		/* oQƂ܂B */
		ptr operator->()const{return _p;}

		/* ̂Ԃ܂B */
		ind getIndirect()const throw(InvalidCallExc){
			if(_pm) return *_p;
			throw InvalidCallExc(1);
		}
		/* |C^Ԃ܂B */
		ptr get(){return _p;}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_pm;}

		/* QƃJEgԂ܂B */
		ulong count()const{return _pm?_pm->count():0;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){dec_del();_pm = NULL;}

		/* w肵|C^NX(^)LXg(dynamic_cast)܂B */
		template <class From>
		static self cast(const managed_ptr<From>& p)throw(std::bad_cast){
			return self(p._pm,reinterpret_cast<From*>(p._pm->get()));
		}
		template <class From>
		static self cast(From* p)throw(std::bad_cast){
			if(!p) throw InvalidParamExc(1);
			T* f = dynamic_cast<T*>(p);
			if(!f) throw std::bad_cast();
			return self(f);
		}

		/* L̕ϐɃANZXȂłB */
		manage_sys::manage_data* _pm;
		T* _p;

	};

	template<class T,size_t Count> class managed_ary{
	public:
		typedef T*						ptr;
		typedef T&						ind;
		typedef const T*				cptr;
		typedef const T&				cind;
		typedef managed_ary<T,Count>	self;

	private:
		void dec_del(){
			if(_pm&&(_pm->dec() == 0)){
				delete[] reinterpret_cast<ptr>(_pm->get());
				delete _pm;
			}
		}

	public:

		/* Rs[RXgN^B */
		managed_ary(self& p){
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* NULL ۗL܂B */
		managed_ary():_pm(NULL){}
		/* |C^ۗL܂B */
		managed_ary(T(&p)[Count])throw(OutOfMemExc):_pm(NULL){
			if(p){
				bool in;
				_pm = manage_sys::manage_data::md_is(p,&in);
				if(!in) _pm = checkNull(new manage_sys::manage_data(_pm,p));
				else _pm->inc();
			}
		}

		~managed_ary(){dec_del();}

		/* |C^Ԃ܂B */
		operator ptr(){return reinterpret_cast<ptr>(_pm->get());}
		operator cptr()const{return reinterpret_cast<ptr>(_pm->get());}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _pm==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == (_pm?_pm->get():NULL);}
		bool operator==(const self& p)const{return _pm == p._pm;}
		bool operator!=(cptr p)const{return p != (_pm?_pm->get():NULL);}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/* w肵|C^NX܂B */
		self& operator=(self& p){set(p);return *this;}
		void set(self& p){
			dec_del();
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* ̂QƂ܂B */
		ind operator*(){return *reinterpret_cast<ptr>(_pm->get());}
		cind operator*()const{return *reinterpret_cast<ptr>(_pm->get());}
		/* oQƂ܂B */
		ptr operator->(){return reinterpret_cast<ptr>(_pm->get());}
		cptr operator->()const{return reinterpret_cast<ptr>(_pm->get());}
		/* w肵ʒũf[^Ԃ܂B */
		ind operator[](ulong i){return reinterpret_cast<ptr>(_pm->get())[i];}
		cind operator[](ulong i)const{return reinterpret_cast<ptr>(_pm->get())[i];}

		/* ̂Ԃ܂B */
		ind getIndirect()throw(InvalidCallExc){
			if(_pm) return *reinterpret_cast<ptr>(_pm->get());
			throw InvalidCallExc(1);
		}
		cind getIndirect()const throw(InvalidCallExc){
			if(_pm) return *reinterpret_cast<ptr>(_pm->get());
			throw InvalidCallExc(1);
		}
		/* |C^Ԃ܂B */
		ptr get(){return _pm?reinterpret_cast<ptr>(_pm->get()):NULL;}
		cptr get()const{return _pm?reinterpret_cast<ptr>(_pm->get()):NULL;}
		/* w肵ʒũf[^Ԃ܂B */
		ind at(ulong i)const throw(InvalidParamExc,InvalidCallExc){
			if(_pm){
				if(i < Count) return reinterpret_cast<ptr>(_pm->get())[i];
				throw InvalidParamExc(1);
			}
			throw InvalidCallExc(2);
		}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_pm;}

		/* QƃJEgԂ܂B */
		ulong count()const{return _pm?_pm->count():0;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){dec_del();_pm = NULL;}

	protected:
		manage_sys::manage_data* _pm;

	};

} // namespace scpl
#endif
