// 
// color.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _color_INCLUDED_
#define _color_INCLUDED_
#include "scpl.h"
#include "utility.h"

namespace scpl{

	/*
		FݒE擾EvZCC֐QłB
	*/

	namespace color{

		/* ARGB lԂ܂B */
		inline ulong toARGB(byte a,byte r,byte g,byte b){return (a<<24) | (r<<16) | (g<<8) | b;}
		/* RGB lԂ܂BAt@l̕ 0xff ɂȂ܂B */
		inline ulong toRGB(byte r,byte g,byte b){return 0xff000000 | (r<<16) | (g<<8) | b;}
		/* ARGBF̒ԐFԂ܂B */
		inline ulong centerARGB(ulong argb1,ulong argb2){
			return
				(center(static_cast<byte>(argb1>>24),static_cast<byte>(argb2>>24))<<24) |
				(center(static_cast<byte>(argb1>>16),static_cast<byte>(argb2>>16))<<16) |
				(center(static_cast<byte>(argb1>>8),static_cast<byte>(argb2>>8))<<8) |
				center(static_cast<byte>(argb1),static_cast<byte>(argb2));
		}
		/* RGBF̒ԐFԂ܂BAt@l̕ a ɂȂ܂B */
		inline ulong centerRGB(ulong rgb1,ulong rgb2,byte a=0xff){
			return (a<<24) |
				(center(static_cast<byte>(rgb1>>16),static_cast<byte>(rgb2>>16))<<16) |
				(center(static_cast<byte>(rgb1>>8),static_cast<byte>(rgb2>>8))<<8) |
				center(static_cast<byte>(rgb1),static_cast<byte>(rgb2));
		}
		/* F𔽓]܂B */
		inline ulong reverseARGB(ulong argb){return ~argb;}
		/* F𔽓]܂BAt@l͔]܂B */
		inline ulong reverseRGB(ulong argb){return argb ^ 0x00ffffff;}

	} // namespace color

} // namespace scpl
#endif
