// 
// Map.h
// 
// Copyright(C) 2007 Ó
#ifndef _Map_INCLUDED_
#define _Map_INCLUDED_
#include "Buffer.h"
#include "smart_ptr.h"
#include <string.h>
namespace scpl{

	/*
		L[ƒlgăf[^ɃANZXNXłB
		̃NXSTLCuč̂ł͂Ȃ̂ŁA
		{Iȋ@\ȊO͓ł͂܂B
		|C^NXǗ̂ŁA\ȂhƂł܂B

		֐̐ɂ镡Ƃ́A|C^NX̃Rs[̂ƂłA
		͕̂܂B
	*/

	template <class KEY,class VAL,class keyptr = smart_ptr<KEY>,class valptr = smart_ptr<VAL> >
	struct Pair{
		typedef Pair<KEY,VAL,keyptr,valptr> self;
		keyptr key;
		valptr val;
		Pair(const KEY& _key,const valptr& _val):key(checkNull(new KEY(_key))),val(_val){}
		bool operator==(const self& p){return equal(p.key)&&equal(p.val);}
		bool operator!=(const self& p){return !equal(p.key)||!equal(p.val);}
		bool equal(const keyptr& k){
			if(key.empty()) return k.empty();
			if(k.empty()) return false;
			return *key == *k;
		}
		bool equal(const valptr& v){
			if(val.empty()) return v.empty();
			if(v.empty()) return false;
			return *val == *v;
		}
		void operator=(const self& p){key = p.key;val = p.val;}
	};

	template <class KEY,class VAL,
		class keyptr = smart_ptr<KEY>,
		class valptr = smart_ptr<VAL>,
		class pairptr = smart_ptr<Pair<KEY,VAL,keyptr,valptr> > >
	class Map{
	public:
		typedef Pair<KEY,VAL,keyptr,valptr>	pair;
		typedef pairptr						ptr_pair;
		typedef const pairptr				cptr_pair;
		typedef pair&						ind_pair;
		typedef const pair&					cind_pair;

		typedef valptr						ptr;
		typedef const valptr				cptr;
		typedef VAL&						ind;
		typedef const VAL&					cind;
		typedef const KEY&					Key;
	private:
		typedef Buffer<ptr_pair>			buf;

		typedef Map<KEY,VAL,keyptr,valptr,pairptr>	self;

		Buffer<ptr_pair> _Data;
		ulong _UseCount;

	public:
		/* ̃}bvA邢͎w肵TCYmۂč쐬܂B */
		Map(ulong c=0)throw(OutOfMemExc):_Data(c,true),_UseCount(0){}

		/* }bv̕𐶐܂B */
		Map(const self& s)throw(OutOfMemExc):_UseCount(0){copy(s);}

		virtual ~Map(){clear();}

		/* f[^݂邩Ԃ܂B*/
		operator bool()const{return !empty();}
		/* f[^݂ȂԂ܂B*/
		bool operator!()const{return empty();}
		/* f[^݂ȂԂ܂B*/
		bool empty()const{return _UseCount == 0;}
		/* ڐԂ܂B */
		ulong count()const{return _UseCount;}
		/* ݂̊i[\Ԃ܂B */
		ulong capacity()const{return _Data.count();}

		/* }bv܂B */
		self& operator=(const self& s)throw(OutOfMemExc){copy(s);return *this;}

		/* }bvԂ܂B */
		bool operator==(const self& s)const{return equals(s);}
		/* }bvłȂԂ܂B */
		bool operator!=(const self& s)const{return !equals(s);}

		/* w肵L[ɑΉf[^|C^Ԃ܂B݂Ȃꍇ͍쐬܂B */
		ptr& operator[](Key key)throw(OutOfMemExc){return get(key);}
		cptr& operator[](Key key)const throw(InvalidParamExc){return get(key);}

		/* w肵L[ɑΉf[^|C^Ԃ܂B */
		ptr& get(Key key)throw(OutOfMemExc){
			long pos = findKey(key);
			if(pos < 0) return set(key);
			return _Data.get()[pos]->val;
		}
		cptr& get(Key key)const throw(InvalidParamExc){
			long pos = findKey(key);
			if(pos < 0) throw InvalidParamExc(1);
			return _Data.get()[pos]->val;
		}

		/*
			f[^Zbg܂BɑΉĂL[ꍇ͏㏑܂B
			key   - }L[
			data  - L[ɑΉf[^
			߂l - }ꂽf[^̃|C^
 		*/
		ptr& set(Key key,ptr data)throw(OutOfMemExc){
			long p = findKey(key);
			if(p < 0){
				if(_UseCount+1 > capacity()) _Data.aResize(_UseCount+1,true);
				ptr_pair* pos = _Data.get() + _UseCount;
				*pos = checkNull(new pair(key,data));
				++_UseCount;
				return (*pos)->val;
			}
			else{
				return _Data.get()[p]->val = data;
			}
		}
		/*
			f[^Zbg܂BɑΉĂL[ꍇ͏㏑܂B
			key   - }L[
			߂l - }ꂽf[^̃|C^
 		*/
		ptr& set(Key key)throw(OutOfMemExc){return set(key,smart_ptr<VAL>());}
		/*
			f[^𕡐ăZbg܂BɑΉĂL[ꍇ͏㏑܂B
			key   - }L[
			data  - L[ɑΉf[^
			߂l - }ꂽf[^̃|C^
 		*/
		ptr& set(Key key,cind t)throw(OutOfMemExc){
			smart_ptr<VAL> sp(checkNull(new VAL(t)));
			return set(key,sp);
		}

		/*
			w肵L[ƂɑΉf[^폜܂B
			key   - 폜L[
			߂l - 폜łǂ
		*/
		bool remove(Key key){
			long p = findKey(key);
			if(p < 0) return false;
			ptr_pair* pos = _Data.get() + p;
			pos->clear();
			if(p != _UseCount - 1){
				memmove(pos,pos + 1,(_UseCount - p) * sizeof(ptr_pair));
				memset(_Data.get() + _UseCount-1,0,sizeof(ptr_pair));
			}
			--_UseCount;
			return true;
		}

		/*
			nꂽ}bv𕡐܂B
			Äɗ]肪oĂ̗͎̈c܂B
		*/
		void copy(const self& s)throw(OutOfMemExc){
			if(this != &s){
				if(s){
					clear(false);
					if(capacity() < s._UseCount) _Data.aResize(s._UseCount,true);
					cptr_pair *si=s._Data.begin(),*sn=s._Data.end();
					ptr_pair *di=_Data.begin();
					for(;si<sn;++si,++di) *di = *si;
					_UseCount = s._UseCount;
				}
				else clear(false);
			}
		}

		/*
			zNA܂B
			capFree - Capacitÿ邩ǂBȗtrueB
		*/
		void clear(bool capFree=true){
			ptr_pair *it = _Data.begin(),*end = _Data.end();
			for(;it<end;++it){
				it->clear();
			}
			if(capFree) _Data.clear();
			_UseCount = 0;
		}

		/* }bvւ܂B */
		void swap(self& s){
			_Data.swap(s._Data);
			scpl::swap(_UseCount,s._UseCount);
		}

		/* L[܂B */
		long findKey(Key key)const{
			cptr_pair *i = _Data.begin(),*n = _Data.end();
			for(long j=0;i<n;++i,++j){
				if(*(*i)->key == key) return j;
			}
			return -1;
		}

	};

	/* managed_ptrNXgpꍇMap^`̃}NłB */
#define DEF_MANAGED_MAP(typeName,key,val) typedef Map<key,val,managed_ptr<key>,managed_ptr<val>,Pair<key,val,managed_ptr<key>,managed_ptr<val> > > typeName

} // namespace scpl
#endif