// 
// List.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _List_INCLUDED_
#define _List_INCLUDED_
#include "Buffer.h"
#include "smart_ptr.h"
#ifdef _MSC_VER
#include <string.h>
#else
#include <mem.h>
#endif

namespace scpl{

	/*
		|C^NXzƂĎNXłB
		̃NXSTLCuč̂ł͂Ȃ̂ŁA
		{@\ȊO͓ł͂܂B
		|C^NXǗ̂ŁA\ȂhƂł܂B

		֐̐ɂ镡Ƃ́A|C^NX̃Rs[̂ƂłA
		͕̂܂B
	*/

	template <class T,class pointer = smart_ptr<T> >
	class List{
	public:
		typedef pointer			ptr;
		typedef const pointer	cptr;
		typedef T&				ind;
		typedef const T&		cind;
	private:
		typedef Buffer<ptr>		buf;
		typedef List<T>			self;

		Buffer<ptr>	_Data;
		ulong		_UseCount;

	public:
		/* ̃XgA邢͎w肵TCYmۂč쐬܂B */
		List(ulong c=0)throw(OutOfMemExc):_Data(c,true),_UseCount(0){}

		/* Xg̕𐶐܂B */
		List(const self& s)throw(OutOfMemExc):_UseCount(0){lastIn(s);}

		virtual ~List(){clear();}

		/* f[^݂邩Ԃ܂B*/
		operator bool()const{return !empty();}
		/* f[^݂ȂԂ܂B*/
		bool operator!()const{return empty();}
		/* f[^݂ȂԂ܂B*/
		bool empty()const{return _UseCount == 0;}
		/* ڐԂ܂B */
		ulong count()const{return _UseCount;}
		/* ݂̊i[\Ԃ܂B */
		ulong capacity()const{return _Data.count();}

		/* Xg܂B */
		self& operator=(const self& s)throw(OutOfMemExc){copy(s);return *this;}

		/* XgԂ܂B */
		bool operator==(const self& s)const{return equals(s);}
		/* XgłȂԂ܂B */
		bool operator!=(const self& s)const{return !equals(s);}

		/* w肵ʒuɂf[^Ԃ܂B */
		ind operator[](ulong index)const{return *_Data.get()[index];}

		/* w肵ʒuɂf[^Ԃ܂B */
		ind at(ulong index)const throw(InvalidParamExc,InvalidCallExc){
			if(index < count()) return *_Data.get()[index];
			if(empty()) throw InvalidCallExc();
			throw InvalidParamExc(1);
		}
		/* 擪̃f[^Ԃ܂B */
		ind atFirst()const throw(InvalidCallExc){return at(0);}
		/* Ō̃f[^Ԃ܂B */
		ind atLast()const throw(InvalidCallExc){return at(_UseCount-1);}

		/*
			p̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr* begin()const{return _Data?_Data.get():NULL;}
		/*
			p̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr* end()const{return _Data?(_Data.get()+_UseCount):NULL;}
		/*
			tp̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr* rbegin()const{return _Data?(_Data.get()+_UseCount-1):NULL;}
		/*
			tp̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr* rend()const{return _Data?(_Data.get()-1):NULL;}

		/*
			f[^w肵ʒuɑ}܂B
			data   - }f[^
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(cptr data,ulong index)throw(InvalidParamExc,OutOfMemExc){
			if(!data) throw InvalidParamExc(1);
			if(index > _UseCount) throw InvalidParamExc(1);
			if(_UseCount+1 > capacity()) _Data.aResize(_UseCount+1,true);
			ptr* pos = _Data.get() + index;
			if(index != _UseCount){
				memmove(pos + 1,pos,(_UseCount - index) * sizeof(ptr));
				memset(pos,0,sizeof(ptr));
			}
			*pos = data;
			++_UseCount;
			return index;
		}
		/*
			f[^w肵ʒuɕđ}܂B
			t      - }f[^
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(cind t,ulong index)throw(InvalidParamExc,OutOfMemExc){
			smart_ptr<T> sp(checkNull(new T(t)));
			ulong r = insert(sp,index);
			return r;
		}
		/*
			Xgw肵ʒuɑ}܂B
			s      - }郊Xg
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(const self& s,ulong index)throw(InvalidParamExc,OutOfMemExc){
			if(!s) throw InvalidParamExc(1);
			if(index > _UseCount) throw InvalidParamExc(1);
			ulong z = s.count();
			if(_UseCount+z > capacity()) _Data.aResize(_UseCount+z,true);
			ptr* pos = _Data.get() + index;
			const ptr* src = s.begin();
			if(index != _UseCount){
				memmove(pos + z,pos,(_UseCount - index) * sizeof(ptr));
				memset(pos,0,z*sizeof(ptr));
			}
			for(ulong a=z;a>0;--a,++pos,++src) *pos = *src;
			_UseCount+=z;
			return index;
		}

		/* f[^擪ɑ}܂B߂l͏0łB */
		ulong firstIn(ptr t)throw(InvalidParamExc,OutOfMemExc){return insert(t,0);}
		/* f[^擪ɕđ}܂B߂l͏0łB */
		ulong firstIn(cind t)throw(InvalidParamExc,OutOfMemExc){
			ptr sp(checkNull(new T(t)));
			ulong r = insert(sp,0);
			return r;
		}
		/* Xg擪ɕđ}܂B߂l͏0łB */
		ulong firstIn(const self& s)throw(InvalidParamExc,OutOfMemExc){return insert(s,0);}

		/* f[^Ōɑ}܂B߂l͑}ꂽʒułB */
		ulong lastIn(ptr t)throw(InvalidParamExc,OutOfMemExc){return insert(t,count());}
		/* f[^Ōɕđ}܂B߂l͑}ꂽʒułB */
		ulong lastIn(cind t)throw(InvalidParamExc,OutOfMemExc){
			ptr sp = checkNull(new T(t));
			ulong r = insert(sp,count());
			return r;
		}
		/* XgŌɕđ}܂B߂l͑}ꂽʒułB */
		ulong lastIn(const self& s)throw(InvalidParamExc,OutOfMemExc){return insert(s,count());}

		/*
			w肵ʒuɂf[^폜܂B
			index  - 폜f[^ւ̈ʒuB{0 <= index < count()} ܂ł͈̔́B
		*/
		void removeAt(ulong index)throw(InvalidParamExc,InvalidCallExc){
			if(_UseCount == 0) throw InvalidCallExc();
			if(index >= _UseCount) throw InvalidParamExc(1);
			ptr* pos = _Data.get() + index;
			pos->clear();
			if(index != _UseCount - 1){
				memmove(pos,pos + 1,(_UseCount - index) * sizeof(ptr));
				memset(_Data.get() + _UseCount-1,0,sizeof(ptr));
			}
			--_UseCount;
		}
		/*
			w肵|C^ʒuɂf[^폜܂B
			R|C^̓obt@̒łKv܂B
		*/
		void remove(cptr* index)throw(InvalidParamExc,InvalidCallExc){removeAt(toPos(index));}

		/* 擪̃f[^폜܂B */
		void firstOut()throw(InvalidCallExc){removeAt(0);}
		/* Ō̃f[^폜܂B */
		void lastOut()throw(InvalidCallExc){removeAt(_UseCount-1);}

		/*
			nꂽXg𕡐܂B
			Äɗ]肪oĂ̗͎̈c܂B
		*/
		void copy(const self& s)throw(OutOfMemExc){
			if(this != &s){
				clear(false);
				if(s) lastIn(s);
			}
		}

		/*
			zNA܂B
			capFree - Capacitÿ邩ǂBȗtrueB
		*/
		void clear(bool capFree=true){
			ptr *it = _Data.begin(),*end = _Data.end();
			for(;it<end;++it) it->clear();
			if(capFree) _Data.clear();
			_UseCount = 0;
		}

		/* Xgւ܂B */
		void swap(self& s){
			_Data.swap(s._Data);
			scpl::swap(_UseCount,s._UseCount);
		}

		/* w肵Xgƈv邩Ԃ܂B */
		bool equals(const self& s)const{
			if(this != &s){
				if(s.count() == count()){
					cptr* l = _Data.get();
					cptr* r = s._Data.get();
					for(ulong i = count();i>0;--i,++l,++r){
						if(*l != *r) return false;
					}
				}
				else return false;
			}
			return true;
		}

		/* z̃|C^CfbNXlԂ܂B */
		ulong toPos(cptr* ptr)const throw(InvalidParamExc){
			if((_Data.get() > ptr)||(_Data.get()+_UseCount <= ptr)){
				throw InvalidParamExc(1);
			}
			return static_cast<ulong>(ptr - _Data.get());
		}

		/*
			mۂĂw肵܂B
			bufCount - mۂĂ
		*/
		void adjust(ulong bufCount=0){_Data.aResize(_UseCount+bufCount,true);}

	};

} // namespace scpl
#endif