// 
// Exceptions.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Exceptions_INCLUDED_
#define _Exceptions_INCLUDED_
#include "scpl.h"
#include "utility.h"
#include <malloc.h>
/*
	Cu̗ONXłBNXp΁A
	[U[`̗ONXpӂł܂B
	܂AȒPȗO`FbN֐pӂĂ܂B
	̗ONXɂ̓bZ[WƃR[hi[܂B
*/

namespace scpl{

	/* CůeO̊NXłB */
	class Exc{
	public:
		Exc(ulong code):_Code(code),_Mes(NULL),_DoDel(false){}
		Exc(ctstr mes,ulong code):_Code(code){setMessage(mes);}
		Exc(ctstr mes,ulong code,int):_Code(code),_Mes(mes),_DoDel(false){}
		Exc(const Exc& exc):_Code(exc._Code),_DoDel(false){
			if(exc._DoDel) setMessage(exc._Mes);
			else{
				_DoDel = false;
				_Mes = exc._Mes;
			}
		}

	protected:
		void setMessage(ctstr txt,int){clear();_Mes = txt;_DoDel=false;}
		void setMessage(ctstr txt);
		void setMessage(size_t maxSize,ctstr txt,...);
		void setCode(ulong code){_Code = code;}
		void clear(){if(_DoDel){free(const_cast<tstr>(_Mes));_Mes = NULL;}}

	public:
		Exc& operator=(const Exc& exc){_Code = exc._Code;clear();setMessage(exc._Mes);return *this;}
		~Exc(){if(_DoDel) free(const_cast<tstr>(_Mes));}

		ctstr message()const{return _Mes;}
		ulong code()const{return _Code;}

	private:
		ulong _Code;	// OR[hBpꂽNXɂĒl̈Ӗς܂B
		ctstr _Mes;		// ObZ[WB
		bool _DoDel;	// ObZ[W邩ǂ

	};

	/* mێsB */
	class OutOfMemExc:public Exc{
	public:
		OutOfMemExc(ulong size):Exc(TC("܂B"),size,0){}
		OutOfMemExc(ctstr mes,ulong code):Exc(mes,code){}
		OutOfMemExc(ctstr mes,ulong code,int):Exc(mes,code,0){}
		SCPLU_CCDEF(OutOfMemExc,Exc)

	};

	/* ȌĂяoB */
	class InvalidCallExc:public Exc{
	public:
		InvalidCallExc():Exc(TC("ȌĂяos܂B"),0,0){}
		SCPLU_CCDEF(InvalidCallExc,Exc)

	};

	/* Ȉw肵ꍇB */
	class InvalidParamExc:public Exc{
	public:
		InvalidParamExc(ulong argpos):Exc(TC("łB"),argpos,0){}
		SCPLU_CCDEF(InvalidParamExc,Exc)

	};

	/* o͗OB */
	class IOExc:public Exc{
	public:
		enum Param{
			UNKNOW		= 0,
			NOT_OPEN	= 1,
			SEEK		= 2,
			FLUSH		= 3,
			NO_OPEN		= 4,
			OPENED		= 5,
			READ		= 6,
			WRITE		= 7,
			ENDOFSEEK	= 8,
		};
		IOExc(Param p);
		SCPLU_CCDEF(IOExc,Exc)

	};

	/* t@COB */
	class FileExc:public Exc{
	public:
		enum Param{
			UNKNOW		= 0,
			NOT_EXIST	= 1,
			NO_OPEN		= 2,
		};
		FileExc(Param p);
		SCPLU_CCDEF(FileExc,Exc)

	};

	/* dꍇB */
	class OverlapExc:public Exc{
	public:
		OverlapExc(ulong code):Exc(TC("d܂B"),code,0){}
		OverlapExc(ctstr mes,ulong code):Exc(mes,code){}
		OverlapExc(ctstr mes,ulong code,int):Exc(mes,code,0){}
		SCPLU_CCDEF(OverlapExc,Exc)

	};

	/*
		WinAPI Ŗ肪̗ONXB
		OR[hWinAPĨG[R[hB
	*/
	class WinAPIExc:public Exc{
		void WinAPIExc_construct();

	public:
		WinAPIExc();
		WinAPIExc(ulong code):Exc(code){WinAPIExc_construct();}
		SCPLU_CCDEF(WinAPIExc,Exc)

	};

	/*
		ΏۂNULLǂ`FbNANULLꍇ
		OutOfMemExcO𔭐܂B
	*/
	template<class T>
	inline T* checkNull(T* t,ulong count=1)throw(OutOfMemExc){
		if(!t) throw OutOfMemExc(TC("܂B"),sizeof(T)*count,0);
		return t;
	}
	template<>
	inline void* checkNull(void* t,ulong count)throw(OutOfMemExc){
		if(!t) throw OutOfMemExc(TC("܂B"),count,0);
		return t;
	}

	/*
		w肵(NULL)ǂ`FbNAꍇ
		InvalidParamExcO𔭐܂B
	*/
	template<class T>
	inline T& checkParam(T& t,ulong argpos=1)throw(InvalidParamExc){
		if(!t) throw InvalidParamExc(TC("łB"),argpos,0);
		return t;
	}

} // namespace scpl

#endif