// 
// CriticalSection.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _CriticalSection_INCLUDED_
#define _CriticalSection_INCLUDED_
#include "scpl.h"
#include <windows.h>

namespace scpl{

	/*
		Windows̃NeBJZNV@\JvZNXłB
	*/
	class CriticalSection{
		CRITICAL_SECTION cs;
	public:
		CriticalSection(){InitializeCriticalSection(&cs);}
		~CriticalSection(){DeleteCriticalSection(&cs);}
		void enter(){EnterCriticalSection(&cs);}
		void leave(){LeaveCriticalSection(&cs);}
	};

	/*
		NeBJZNVNXgpÃNX̃RXgN^
		fXgN^͈̔͂ŃNeBJZNVɓ⏕NXłB
		RXgN^Ɏw肳ꂽNeBJZNVNX
		CX^X݂钆Ŏgp(enter)ƌł܂܂̂
		ӂĂB
		)
		CriticalSection* cs = new CriticalSection;
		{
			Synchronize(cs); // csenter
			{
				Synchronize(cs); // csenter̂Ōł܂B
			}
		}
	*/
	class Synchronize{
		CriticalSection* pCS;
	public:
		Synchronize();
		Synchronize(CriticalSection* pCS_):pCS(pCS_){pCS_->enter();}
		~Synchronize(){pCS->leave();}
	};

	typedef Synchronize Sync;
	typedef CriticalSection CS;
	typedef CriticalSection* PCS;

#define SYNC(s) scpl::Sync sync(s)

} // namespace scpl
#endif