// 
// Argument.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Argument_INCLUDED_
#define _Argument_INCLUDED_
#include "String.h"
#include "List.h"

#pragma comment (lib,"shlwapi.lib")

namespace scpl{

/*
	ϊW[łB

	p[^ѕnƁA̕w肵
	pŕAzƂĐ܂B
	nꂽ̓Rs[̂ŁAnɑ΂ˑ֌W͎܂B

	̃W[ WinAPI gpA "shlwapi.lib" N܂B

*/
	namespace argument{
		typedef List<AString> ArgVA;
		typedef List<WString> ArgVW;

		/* createArgumentFromCommandLine ֐ŎgAargv[0]ɂ */
		enum ARGTYPE{
			NONE=0,  // spXꂸAl߂
			CONSOLE, // R\[ƓAspX
			EXENAME, // EChEƓAst@C
			EXEPATH, // spXtpXœ
			DIR,     // sJgfBNg
			EXEDIR,  // st@C̃fBNg
		};

		/*
			𕪊Azɕϊ܂B
			؂镶w肷邱Ƃł܂B
			arg     - ̕B
			divide  - ؂蕶Bȗ͋󔒕(p󔒁E^uEs)B
			isQuote -  '  " ݂̈͂؂Ƃ邩ǂB
			return  - ꂽzB
			<O>
            OutOfMemExc     - 邽߂ɕKvȗeʂȂB
			InvalidParamExc - nꂽ NULL B
			                  邢͋؂蕶 '  " w肵B
		*/
		ArgVA* createArgumentA(cstr txt,cstr divide = NULL,bool isQuote = true)throw(InvalidParamExc,OutOfMemExc);
		ArgVW* createArgumentW(cwstr txt,cwstr divide = NULL,bool isQuote = true)throw(InvalidParamExc,OutOfMemExc);

		/*
			Nɓnꂽzɕϊ܂B
			type   - z̐擪̏@Bȗ CONSOLE B
			return - ̔zB
			<O>
			OutOfMemExc     - 邽߂ɕKvȗeʂȂB
		*/
		ArgVA* createArgumentFromCommandLineA(ARGTYPE type = CONSOLE)throw(OutOfMemExc);
		ArgVW* createArgumentFromCommandLineW(ARGTYPE type = CONSOLE)throw(OutOfMemExc);

		/*
			NɓnꂽR\[^zɕϊ܂B
			argc   - z̐擾ϐւ̃|C^B
			argv   - z擾ϐւ̃|C^B
            type   - z̐擪̏@Bȗ CONSOLE B
			<O>
			OutOfMemExc  - Rs[eʂ
		*/
		void commandLineToArgvA(int* argc,str** argv,ARGTYPE type = CONSOLE)throw(InvalidParamExc,OutOfMemExc);
		void commandLineToArgvW(int* argc,wstr** argv,ARGTYPE type = CONSOLE)throw(InvalidParamExc,OutOfMemExc);

		/* nCubh֐ */
#ifdef _UNICODE
		inline ArgVW* createArgument(cwstr txt,cwstr divide = NULL,bool isQuote = true)throw(InvalidParamExc,OutOfMemExc){
			return createArgumentW(txt,divide,isQuote);
		}
		inline ArgVW* createArgumentFromCommandLine(ARGTYPE type = CONSOLE)throw(OutOfMemExc){
			return createArgumentFromCommandLineW(type);
		}
		inline void commandLineToArgv(int* argc,wstr** argv,ARGTYPE type = CONSOLE)throw(InvalidParamExc,OutOfMemExc){
			commandLineToArgvW(argc,argv,type);
		}
#else
		inline ArgVA* createArgument(cstr txt,cstr divide = NULL,bool isQuote = true)throw(InvalidParamExc,OutOfMemExc){
			return createArgumentA(txt,divide,isQuote);
		}
		inline ArgVA* createArgumentFromCommandLine(ARGTYPE type = CONSOLE)throw(OutOfMemExc){
			return createArgumentFromCommandLineA(type);
		}
		inline void commandLineToArgv(int* argc,str** argv,ARGTYPE type = CONSOLE)throw(InvalidParamExc,OutOfMemExc){
			commandLineToArgvA(argc,argv,type);
		}
#endif
	}

} // namespace scpl
#endif