package hayashi.osm.api;
import hayashi.kiban.ConvAdmPt25000;
import hayashi.kiban.ConvBusstop;
import hayashi.kiban.ConvBusstopGML;
import hayashi.kiban.ConvRdComPt;
import hayashi.kiban.DbBuscourse;
import hayashi.kiban.DbBusref;
import hayashi.kiban.DbBusstop;
import hayashi.osm.tracker.Gpx2osm;

import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;

import org.xml.sax.*;

import java.io.*;
import java.sql.SQLException;

public class Command {

	String filter = "";
	String urlStr = "";


	public static final boolean DB_INIT = false;

	// 近くのバス停を探す範囲（バス停を中心としたNEER×２ｍ四方の領域
	static final int NEER = 75;

	/**
	 * メイン
	 *
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException
	 * @throws TransformerException
	 * @throws SAXException
	 * @throws ParserConfigurationException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, SQLException, IOException, ParserConfigurationException, SAXException, TransformerException
	{
		int index = 0;
		if (args.length > index) {
			if (args[index].equals("DbBuscourse")) {
				DbBuscourse.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("DbBusstop")) {
				DbBusstop.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("DbBusref")) {
				DbBusref.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("Gpx2osm")) {
				Gpx2osm.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvAdmPt25000")) {
				ConvAdmPt25000.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvRdComPt")) {
				ConvRdComPt.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvBusstop")) {
				ConvBusstop.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvBusstopGML")) {
				ConvBusstopGML.main(shiftArgs(args));
				return;
			}
		}
		System.out.println("OSM converter command.");
		System.out.println("exp:");
		System.out.println("> java -jar OsmConverter.jar <function>");
		System.out.println("\t    DbBuscourse : 'table.bus_course'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t      DbBusstop : 'table.BUS_STOP'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t       DbBusref : 'table.BUS_REF'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t        Gpx2osm : ");
		System.out.println("\t    ConvRdComPt : ");
		System.out.println("\t    ConvBusstop : ");
		System.out.println("\t ConvBusstopGML : ");
	}


	static String[] shiftArgs(String[] args) {
		String[] values = new String[args.length - 1];
		for (int i=1; i < args.length; i++) {
			values[i - 1] = new String(args[i]);
		}
		return values;
	}
}