package jp.co.areaweb.tools.mail;

import javax.xml.parsers.*;         // jaxp.jar
import org.w3c.dom.*;               // jaxp.jar
import java.io.FileInputStream;

public class SiteDataXml extends SiteData {
    public SiteDataXml(String propertyFile) throws javax.xml.parsers.ParserConfigurationException,org.xml.sax.SAXException {
    	super(propertyFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Node rootNode = builder.parse(new FileInputStream(propertyFile));
            NodeList rootNodeList = rootNode.getChildNodes();
            for (int j=0; j < rootNodeList.getLength(); j++) {
                Node propertyTag = rootNodeList.item(j);
                NodeList nl = propertyTag.getChildNodes();
                for (int i=0; i < nl.getLength(); i++) {
                    Node mailDataTag = nl.item(i);
                    if (mailDataTag.getNodeType() == Node.ELEMENT_NODE) {
                        String nodeName = mailDataTag.getNodeName();
                        if (nodeName.equals("smtp")) {
                            this.MAIL_SMTP = paseValue(mailDataTag);
                        }
                        else if (nodeName.equals("from")) {
                            this.MAIL_FROM = paseValue(mailDataTag);
                        }
                        else if (nodeName.equals("to")) {
                            this.MAIL_TO = paseValue(mailDataTag);
                        }
                        else if (nodeName.equals("cc")) {
                            this.MAIL_CC = paseValue(mailDataTag);
                        }
                        else if (nodeName.equals("bcc")) {
                            this.MAIL_BCC = paseValue(mailDataTag);
                        }
                    }
                }
            }
        }
        catch(Exception e) {
            // Print out the error message
            System.out.println(e);
        }
    }
    
    protected static String paseValue(Node tag) {
        Node node = tag.getFirstChild();
        if (node != null) {
            return node.getNodeValue();
        }
        else {
            return "";
        }
    }
}
