package jp.co.areaweb.tools.command;
import java.io.*;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.util.Date;

/**
 * 指定された時刻以降に更新されたファイルをリストアップし、その絶対パス名を標準出力に出力する。
 */
public class NewFileList
{
    public static void main (String args[]) {
        if (args.length < 2) {
            System.out.println("jp.co.areaweb.tools.command.NewFileList [directory] [CCYY.MM.DD-HH:mm:ss]");
            return;
        }
        
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd'-'hh:mm:ss");
            Date startTime = sdf.parse(args[1], new ParsePosition(0));

            NewFileList.listup(new File(args[0]), startTime);
        }
        catch(Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
    }
    
    public static void listup(File file, Date startTime) throws IOException {
        if (file == null) {
            System.out.println("ERR: ディレクトリが見つかりませんでした。");
            return;
        }
        
        if (file.isDirectory()) {
            File files[] = file.listFiles();
            if (files != null) {
                for (int i=0; i < files.length; i++) {
                    listup(files[i], startTime);    // 再帰呼び出し
                }
            }
        }
        else {
            if ((new Date(file.lastModified())).after(startTime)) {
                System.out.println(file.getAbsolutePath());
            }
        }
        return;
    }

}
