package hayashi.osm.api;
import hayashi.kiban.ConvAdmPt25000;
import hayashi.kiban.ConvBusstop;
import hayashi.kiban.ConvBusstopGML;
import hayashi.kiban.ConvCommPt;
import hayashi.kiban.ConvRdComPt;
import hayashi.kiban.DbBuscourse;
import hayashi.kiban.DbBusref;
import hayashi.kiban.DbBusstop;
import hayashi.osm.tracker.Gpx2osm;

import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;

import org.xml.sax.*;

import java.io.*;
import java.sql.SQLException;

public class Command {

	String filter = "";
	String urlStr = "";


	public static final boolean DB_INIT = false;

	// 近くのバス停を探す範囲（バス停を中心としたNEER×２ｍ四方の領域
	static final int NEER = 75;

	/**
	 * メイン
	 *
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException
	 * @throws TransformerException
	 * @throws SAXException
	 * @throws ParserConfigurationException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, SQLException, IOException, ParserConfigurationException, SAXException, TransformerException
	{
		int index = 0;
		if (args.length > index) {
			if (args[index].equals("DbBuscourse")) {
				DbBuscourse.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("DbBusstop")) {
				DbBusstop.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("DbBusref")) {
				DbBusref.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("Gpx2osm")) {
				Gpx2osm.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvCommPt")) {
				ConvCommPt.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvAdmPt25000")) {
				ConvAdmPt25000.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvRdComPt")) {
				ConvRdComPt.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvBusstop")) {
				ConvBusstop.main(shiftArgs(args));
				return;
			}
			else if (args[index].equals("ConvBusstopGML")) {
				ConvBusstopGML.main(shiftArgs(args));
				return;
			}
		}
		System.out.println("OSM converter command.");
		System.out.println("exp:");
		System.out.println("> java -jar OsmConverter.jar <function>");
		System.out.println("\t    DbBuscourse : 'table.bus_course'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t      DbBusstop : 'table.BUS_STOP'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t       DbBusref : 'table.BUS_REF'の内容をCSV形式にして標準出力に出力する");
		System.out.println("\t        Gpx2osm : ");
		System.out.println("\t     ConvCommPt : ");
		System.out.println("\t ConvAdmPt25000 : ");
		System.out.println("\t    ConvRdComPt : ");
		System.out.println("\t    ConvBusstop : ");
		System.out.println("\t ConvBusstopGML : ");
	}

	public static String getCodeName(int code) {
		switch (code) {
		case 1:
			return "北海道";
		case 2:
			return "青森県";
		case 3:
			return "岩手県";
		case 4:
			return "宮城県";
		case 5:
			return "秋田県";
		case 6:
			return "山形県";
		case 7:
			return "福島県";
		case 8:
			return "茨城県";
		case 9:
			return "栃木県";
		case 10:
			return "群馬県";
		case 11:
			return "埼玉県";
		case 12:
			return "千葉県";
		case 13:
			return "東京都";
		case 14:
			return "神奈川県";
		case 15:
			return "新潟県";
		case 16:
			return "富山県";
		case 17:
			return "石川県";
		case 18:
			return "福井県";
		case 19:
			return "山梨県";
		case 20:
			return "長野県";
		case 21:
			return "岐阜県";
		case 22:
			return "静岡県";
		case 23:
			return "愛知県";
		case 24:
			return "三重県";
		case 25:
			return "滋賀県";
		case 26:
			return "京都府";
		case 27:
			return "大阪府";
		case 28:
			return "兵庫県";
		case 29:
			return "奈良県";
		case 30:
			return "和歌山";
		case 31:
			return "鳥取県";
		case 32:
			return "島根県";
		case 33:
			return "岡山県";
		case 34:
			return "広島県";
		case 35:
			return "山口県";
		case 36:
			return "徳島県";
		case 37:
			return "香川県";
		case 38:
			return "愛媛県";
		case 39:
			return "高知県";
		case 40:
			return "福岡県";
		case 41:
			return "佐賀県";
		case 42:
			return "長崎県";
		case 43:
			return "熊本県";
		case 44:
			return "大分県";
		case 45:
			return "宮崎県";
		case 46:
			return "鹿児島";
		case 47:
			return "沖縄県";
		}
		return "";
	}

	static String[] shiftArgs(String[] args) {
		String[] values = new String[args.length - 1];
		for (int i=1; i < args.length; i++) {
			values[i - 1] = new String(args[i]);
		}
		return values;
	}
}