/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.hsqldb.lib.ReaderInputStream;

public class DataOutputStream
extends BufferedOutputStream {
    byte[] tempBuffer = new byte[8];

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream, 8);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeInt(int n) throws IOException {
        int n2 = 0;
        this.tempBuffer[n2++] = (byte)(n >>> 24);
        this.tempBuffer[n2++] = (byte)(n >>> 16);
        this.tempBuffer[n2++] = (byte)(n >>> 8);
        this.tempBuffer[n2++] = (byte)n;
        this.write(this.tempBuffer, 0, n2);
    }

    public final void writeLong(long l) throws IOException {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeChar(int n) throws IOException {
        int n2 = 0;
        this.tempBuffer[n2++] = (byte)(n >>> 8);
        this.tempBuffer[n2++] = (byte)n;
        this.write(this.tempBuffer, 0, n2);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = 0;
            this.tempBuffer[n2++] = (byte)(c >>> 8);
            this.tempBuffer[n2++] = (byte)c;
            this.write(this.tempBuffer, 0, n2);
        }
    }

    public void writeChars(char[] cArray) throws IOException {
        this.writeChars(cArray, cArray.length);
    }

    public void writeChars(char[] cArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            int n2 = 0;
            this.tempBuffer[n2++] = (byte)(c >>> 8);
            this.tempBuffer[n2++] = (byte)c;
            this.write(this.tempBuffer, 0, n2);
        }
    }

    public long write(Reader reader, long l) throws IOException {
        ReaderInputStream readerInputStream = new ReaderInputStream(reader);
        return this.write(readerInputStream, l * 2L) / 2L;
    }

    public long write(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[1024];
        long l2 = 0L;
        while (true) {
            long l3;
            if ((l3 = l - l2) > (long)byArray.length) {
                l3 = byArray.length;
            }
            if ((l3 = (long)inputStream.read(byArray, 0, (int)l3)) < 1L) break;
            this.write(byArray, 0, (int)l3);
            l2 += l3;
        }
        return l2;
    }
}

