package com.jm;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;

import com.jm.utility.BaseActivity;

public class Menu2 extends BaseActivity {
    public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.menu2);

	    Bundle extras = getIntent().getExtras();
	    final int index = extras.getInt("INDEX");
	    PatternList patternList = new PatternList(null, index);
	    CharSequence[] list = new CharSequence[patternList.size()];
	    for (int i = 0; i < patternList.size(); i++){
	    	JmPattern pattern = patternList.get(i);
	    	list[i] = pattern.getName();
	    }
	    
		ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(this, android.R.layout.simple_list_item_1, list);
		ListView listView = (ListView)findViewById(R.id.Menu2);
		listView.setAdapter(adapter);

		listView.setOnItemClickListener(new OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				Intent intent = new Intent(Menu2.this, (Class<?>)JuggleView.class);
				intent.putExtra("INDEX1", index);
				intent.putExtra("INDEX2", position);
				startActivityForResult(intent, -1);
			}			
		});
    }
}
