function Body(){
	this.initialize.apply(this);
}

Body.HAND_X = [ 18, 6 ];
Body.HAND_Y = [-1,-1 ];

Body.prototype = {
	hx: 0,
	hy: 0,
	hr: 0,
	rx: null,
	ry: null,
	lx: null,
	ly: null,
	rhand: null,
	lhand: null,

	initialize: function() {
		this.rhand = new Ball(true);
		this.lhand = new Ball(true);
		this.rx = new Array(6 + Body.HAND_X.length);
		this.ry = new Array(6 + Body.HAND_Y.length);
		this.lx = new Array(6 + Body.HAND_X.length);
		this.ly = new Array(6 + Body.HAND_Y.length);
	},
	getRightHand: function() {
		return this.rhand;
	},
	getLeftHand: function() {
		return this.lhand;
	},
	drawBody: function(jc){
		var i;
		for(i = 1; i < this.rx.length; i++) {
			jc.drawLine(
				this.rx[i-1], this.ry[i-1], this.rx[i], this.ry[i]);
			jc.drawLine(
				this.lx[i-1], this.ly[i-1], this.lx[i], this.ly[i]);
		}
		jc.drawCircle(this.hx, this.hy, this.hr);
	},
	move: function() {
		var i = Body.HAND_X.length;
		this.rx[i] = this.rhand.getX();
		this.ry[i] = this.rhand.getY();
		this.lx[i] = this.lhand.getX();
		this.ly[i] = this.lhand.getY();

		var j;
		for (j = 0; j < Body.HAND_X.length; j++) {
			this.rx[j] = this.rx[i] - Body.HAND_X[j];
			this.ry[j] = this.ry[i] - Body.HAND_Y[j];
			this.lx[j] = this.lx[i] + Body.HAND_X[j];
			this.ly[j] = this.ly[i] - Body.HAND_Y[j];
		}
		i++;

		this.rx[i] = toInt(this.rx[i-1]) / 3 + 60;
		this.lx[i] = toInt(this.lx[i-1]) / 3 - 60;
		this.ry[i] = toInt(this.ry[i-1]) / 2 - 10;
		this.ly[i] = toInt(this.ly[i-1]) / 2 - 10;
		i++;
		this.rx[i] = toInt(this.rx[i-1]) / 4 + 45;
		this.lx[i] = toInt(this.lx[i-1]) / 4 - 45;
		this.ry[i] = toInt(this.ry[i-1]) / 3 - 63;
		this.ly[i] = toInt(this.ly[i-1]) / 3 - 63;
		i++;
		this.rx[i] = toInt(this.rx[i-1]) / 3 + 20;
		this.lx[i] = toInt(this.lx[i-1]) / 3 - 20;
		this.ry[i] = toInt(this.ry[i-1]) / 3 - 59;
		this.ly[i] = toInt(this.ly[i-1]) / 3 - 59;
		var mx = this.rx[i] + this.lx[i];
		var my = this.ry[i] + this.ly[i];
		i++;
		this.rx[i] = toInt((mx + this.rx[i-1]) / 3);
		this.lx[i] = toInt((mx + this.lx[i-1]) / 3);
		this.ry[i] = toInt((my + this.ry[i-1]) / 3);
		this.ly[i] = toInt((my + this.ly[i-1]) / 3);
		i++;
		this.hx = toInt(mx / 2);
		this.hy = toInt(my / 3) - 52;
		this.hr = 20;
		this.rx[i] = this.hx + 12;
		this.lx[i] = this.hx - 12;
		this.ry[i] = this.hy + 20;
		this.ly[i] = this.ry[i];
	}
};
