function Ball(isHand){
	this.initialize.apply(this, [ isHand ]);
}

Ball.RADIUS = 10;
Ball.LMAX = 200;
Ball.OBJECT_UNDER = 0x02;
Ball.OBJECT_MOVE = 0x04;
Ball.OBJECT_MOVE2 = 0x08;
Ball.balls = null;

Ball.prototype = {
	initBh: 0,
	initC: 0,
	initHand: false,

	bh: 0,
	c: 0,
	c0: 0,
	chand: 0,
	thand: 0,
	gx: 0,
	gy: 0,
	isHand: false,
	status: 0,

	initialize: function(isHand) {
		this.isHand = isHand;
	},
	getX: function(){
		return this.gx;
	},
	getY: function(){
		return this.gy;
	},
	init: function(bh, c, hand) {
		this.initBh = bh;
		this.initC = c;
		this.initHand = hand;
		this.reset();
	},
	reset: function(){
		this.status = 0;
		this.bh = this.initBh;
		this.c = this.initC;
		if (this.initHand) {
			this.thand = 1;
			this.chand = 1;
		} else {
			this.thand = 0;
			this.chand = 0;
		}
		this.gx = 0;
		this.gy = 0;
	},
	setEnable: function(st) {
		this.status |= st;
	},
	setDisable: function(st) {
		this.status &= ~st;
	},
	isEnable: function(st) {
		return ((this.status & st) != 0);
	},
	juggle: function(siteswap, timeCount){
		var ret = false;
		var tp;
		if (this.c < 0 && timeCount >= -this.c * Ball.balls.getTW()) {
			this.c = -this.c;
		}
		while (true) {
			tp = toInt(timeCount - Ball.balls.getTW() * Math.abs(this.c));
			if (tp < Ball.balls.getAW()){
				break;
			}
			this.setDisable(Ball.OBJECT_UNDER);
			this.c0 = this.c;
			if (this.isHand) {
				this.c += 2;
				ret = true;
			} else {
				var t = this.c;
				if (siteswap.isSynchronous() && this.chand != 0){
					t++;
				}
				var multi = Ball.balls.getNowNumberOfMultiplex(t);
				this.bh = siteswap.getValue(t, multi);
				this.c += Math.abs(this.bh);
				this.thand = this.chand;
				if (((this.bh & 1) != 0) || this.bh < 0) {
					this.chand = 1 - this.chand;
				}
				ret = true;
			}
		}

		if (this.c >= 0 && tp >= 0 && !this.isEnable(Ball.OBJECT_UNDER)) {
			this.setEnable(Ball.OBJECT_UNDER);

			if (this.isHand) {
				if (this.isEnable(Ball.OBJECT_MOVE2)) {
					this.setEnable(Ball.OBJECT_MOVE);
					this.setDisable(Ball.OBJECT_MOVE2);
				} else {
					this.setDisable(Ball.OBJECT_MOVE);
				}
			} else {
				var t = this.c;
				if (siteswap.isSynchronous() && this.chand != 0){
					t++;
				}
				t %= siteswap.size();
				if (this.bh == 1) {
					this.setEnable(Ball.OBJECT_MOVE);
				} else {
					this.setDisable(Ball.OBJECT_MOVE);
				}
				var i;
				for (i = 0; i < siteswap.setSize(t); i++) {
					var h = siteswap.getValue(t, i);
					if (h == 1) {
						if (this.chand != 0) {
							Ball.balls.lhand.setEnable(Ball.OBJECT_MOVE2);
						} else {
							Ball.balls.rhand.setEnable(Ball.OBJECT_MOVE2);
						}
					}
					if (h != 2) {
						if (this.chand != 0) {
							Ball.balls.rhand.setEnable(Ball.OBJECT_MOVE2);
						} else {
							Ball.balls.lhand.setEnable(Ball.OBJECT_MOVE2);
						}
						this.setEnable(Ball.OBJECT_MOVE);
					}
				}
			}
		}
		var tpo = null
		var rpo = null;
		if (!this.isEnable(Ball.OBJECT_MOVE)) {
			if (this.c < 0) {
				tpo = Ball.balls.handPosition(this, -this.c, this.chand);
				rpo = tpo;
			} else if (this.isEnable(Ball.OBJECT_UNDER)) {
				tpo = Ball.balls.handPosition(this, this.c, this.chand);
				rpo = Ball.balls.handPosition(this, this.c + 2, this.chand);
				if (tpo[0] != rpo[0] || tpo[1] != rpo[1]) {
					rpo = Ball.balls.handPosition(
						this, this.c + 1, this.chand);
					if (tpo[0] != rpo[0] || tpo[1] != rpo[1]) {
						this.setEnable(Ball.OBJECT_MOVE);
					}
				}
			} else {
				tpo = Ball.balls.handPosition(this, this.c - 2, this.chand);
				rpo = Ball.balls.handPosition(this, this.c, this.chand);
				if (tpo[0] != rpo[0] || tpo[1] != rpo[1]) {
					tpo = Ball.balls.handPosition(
						this, this.c - 1, this.chand);
					if (tpo[0] != rpo[0] || tpo[1] != rpo[1]) {
						this.setEnable(Ball.OBJECT_MOVE);
					}
				}
			}
		}
		if (this.isEnable(Ball.OBJECT_MOVE)) {
			if (this.bh == 1) {
				tpo = Ball.balls.handPosition(this, this.c0 + 1, this.thand);
				rpo = Ball.balls.handPosition(this, this.c + 1, this.chand);
			} else if (this.isEnable(Ball.OBJECT_UNDER)) {
				tpo = Ball.balls.handPosition(this, this.c, this.chand);
				rpo = Ball.balls.handPosition(this, this.c + 1, this.chand);
			} else {
				tpo = Ball.balls.handPosition(this, this.c0 + 1, this.thand);
				rpo = Ball.balls.handPosition(this, this.c, this.chand);
			}
		}
		var D = 6000;

		if (!this.isHand && this.c < 0) {
			this.gy = D * tpo[1] * 12;
			if (tpo[0] == 0) {									// コメントアウトしても変わりなし？
				this.gx = 0;
				this.gy -= (D * tp * 20 / Ball.balls.getTW());
			} else if (tpo[0] > 0) {
				this.gx = (D * tpo[0] / 10)
					- (D * tp / 6 / Ball.balls.getTW());
			} else {
				this.gx = (D * tpo[0] / 10)
					+ (D * tp / 6 / Ball.balls.getTW());
			}
		} else if (!this.isEnable(Ball.OBJECT_MOVE)) {					//動き始める前の手の位置？
			this.gx = D * tpo[0] / 10;
			this.gy = D * tpo[1] * 12;
		} else {												// 投げた後の位置？
			if (this.bh == 1) {
				this.gx = D * 2 * (tp - Ball.balls.getAW())
					/ Ball.balls.getTW() + D;
				this.gy = Ball.balls.getHigh(1);
			} else if (this.isEnable(Ball.OBJECT_UNDER)) {
				this.gx = D * 2 * tp / Ball.balls.getAW() - D;
				this.gy = Ball.balls.getHigh(0);
			} else {
				this.gx = D * 2 * tp / (Ball.balls.getTW() * Math.abs(this.bh)
					- Ball.balls.getAW()) + D;
				this.gy = Ball.balls.getHigh(Math.abs(this.bh));
			}
			this.gy *= (D - this.gx * this.gx / D);
			this.gy += (this.gx * (rpo[1] - tpo[1]) + D * (rpo[1] + tpo[1]))
				* 6;
			this.gx = (this.gx * (rpo[0] - tpo[0]) + D * (rpo[0] + tpo[0]))
				/ 20;
		}
		this.gx = this.gx * 60 / D;
		this.gy = -this.gy / D;
		if (this.isHand) {
			if (this.chand != 0){
				this.gx += Ball.RADIUS;
			}
			else {
				this.gx -= Ball.RADIUS;
			}
		}
		else {
			this.gy -= Ball.RADIUS;
		}
		return ret;
	}
};
