package com.yuji.ef.utility;

import android.content.Context;
import android.content.Intent;

public class EvernoteIntentUtil {
	// Names of Evernote-specific Intent actions and extras
	private static final String ACTION_NEW_NOTE = "com.evernote.action.CREATE_NEW_NOTE";
	private static final String ACTION_NEW_SNAPSHOT = "com.evernote.action.NEW_SNAPSHOT";
	private static final String ACTION_NEW_VOICE_NOTE = "com.evernote.action.NEW_VOICE_NOTE";
	private static final String ACTION_NEW_SEARCH = "com.evernote.action.SEARCH";
	private static final String ACTION_VIEW_NOTE = "com.evernote.action.VIEW_NOTE";
	private static final String ACTION_SEARCH_NOTES = "com.evernote.action.SEARCH_NOTES";

	private static final String EXTRA_NOTE_GUID = "NOTE_GUID";
	private static final String EXTRA_FULL_SCREEN = "FULL_SCREEN";
	private static final String EXTRA_TAGS = "TAG_NAME_LIST";
	private static final String EXTRA_NOTEBOOK_GUID = "NOTEBOOK_GUID";
	private static final String EXTRA_SOURCE_URL = "SOURCE_URL";
	private static final String EXTRA_SOURCE_APP = "SOURCE_APP";
	private static final String EXTRA_AUTHOR = "AUTHOR";
	private static final String EXTRA_QUICK_SEND = "QUICK_SEND";

	public static EvernoteIntentUtil getInstance() {
		if (instance == null) {
			instance = new EvernoteIntentUtil();
		}
		return instance;
	}

	private static EvernoteIntentUtil instance = null;

	private EvernoteIntentUtil() {

	}

	public void viewNote(Context context, String noteGuid) {
		//String noteGuid = "8323550a-8e99-4100-b638-d4f07fd1c815";
		//boolean hideTitleBar = true;
		boolean hideTitleBar = false;

		Intent intent = new Intent();
		intent.setAction(ACTION_VIEW_NOTE);
		intent.putExtra(EXTRA_NOTE_GUID, noteGuid);
		intent.putExtra(EXTRA_FULL_SCREEN, hideTitleBar);
		try {
			context.startActivity(intent);
		} catch (android.content.ActivityNotFoundException ex) {
			// TODO
		}
	}

}
