package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.FolderUtil;

public class NodeDao implements IDao<Node> {
	private static IDao<Node> instance = null;
	public static final String DELM = "\t";
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateChildrenStmt = null;
	private SQLiteStatement updateStatusStmt = null;
	private SQLiteStatement updateNameStmt = null;
	private SQLiteStatement updateParentStmt = null;
	private SQLiteStatement deleteStmt = null;
	private SQLiteStatement deleteIdStmt = null;

	public static IDao<Node> getInstance() {
		if (instance == null) {
			instance = new NodeDao();
		}
		return instance;
	}

	private NodeDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE Node (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "TYPE INTEGER,"
				+ "GUID TEXT," + "PARENT INTEGER," + "NAME TEXT,"
				+ "CHILDREN TEXT," + "STATUS INTEGER" + ");");
	}

	public void init(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO Node (" + "TYPE,"
				+ "GUID," + "PARENT," + "NAME," + "CHILDREN," + "STATUS"
				+ ") VALUES (" + "?,?,?,?,?,?" + ");");
		updateChildrenStmt = db
				.compileStatement("UPDATE Node SET CHILDREN = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateStatusStmt = db
				.compileStatement("UPDATE Node SET STATUS = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateNameStmt = db.compileStatement("UPDATE Node SET NAME = ? WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
		updateParentStmt = db
				.compileStatement("UPDATE Node SET PARENT = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		deleteStmt = db.compileStatement("DELETE FROM Node");
		deleteIdStmt = db.compileStatement("DELETE FROM Node WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
	}

	public void start(SQLiteDatabase db) {
		FolderUtil util = FolderUtil.getInstance();
		util.init(db);
	}

	public void start2(SQLiteDatabase db) {
		// top = new DirNode(null, null);
		// top.setStatus(Node.Status.OPEN);
		//
		// Node node;
		// node = new DirNode("ディレクトリ", null);
		// top.add(node);
		// node.add(new FileNode("ファイルaaa", null));
		// node.add(new FileNode("ファイルbb", null));
		// node.add(new FileNode("ファイルc", null));
		//
		// node = new DirNode("ディレクトリAAA", null);
		// top.add(node);
		// node.add(new DirNode("directory qqqq", null));
		// node.add(new FileNode("ファイルdddddddd", null));
		// node.add(new FileNode("ファイルeee", null));
		//
		// node = new FileNode("ファイルzzz", null);
		// top.add(node);

		Node node;
		Node n;
		long id;
		Node top = new RootNode("", null);
		id = addNT(top);
		top.setId(id);

		// NODE
		node = new DirNode("ディレクトリ", null);
		node.setParent(top.getId());
		id = addNT(node);
		node.setId(id);
		addChildrenIdNT(top, node.getId());
		// top.add(node.getId());

		// SUB
		n = new FileNode("ファイルaaa", null);
		n.setParent(node.getId());
		id = addNT(n);
		addChildrenIdNT(node, id);
		// node.add(n.getId());
		n = new FileNode("ファイルbb", null);
		n.setParent(node.getId());
		id = addNT(n);
		addChildrenIdNT(node, id);
		// node.add(n.getId());
		n = new FileNode("ファイルc", null);
		n.setParent(node.getId());
		id = addNT(n);
		addChildrenIdNT(node, id);
		// node.add(n.getId());

		// NODE
		node = new DirNode("ディレクトリAAA", null);
		node.setParent(top.getId());
		id = addNT(node);
		addChildrenIdNT(top, id);
		// top.add(node.getId());

		// SUB
		n = new DirNode("ディレクトリ", null);
		n.setParent(node.getId());
		id = addNT(n);
		addChildrenIdNT(node, id);
		// node.add(n.getId());
		n = new FileNode("yyyファイル", null);
		n.setParent(node.getId());
		id = addNT(n);
		addChildrenIdNT(node, id);
		// node.add(n.getId());

		// NODE
		node = new FileNode("ファイルあいうえお", null);
		node.setParent(top.getId());
		id = addNT(node);
		addChildrenIdNT(top, id);
		// top.add(node.getId());
	}

	public List<Node> search() {
		return search(DatabaseHelper.getInstance().getSQLiteDatabase(), null,
				null, null);
	}

	public Node searchRoot() {
		return searchRoot(DatabaseHelper.getInstance().getSQLiteDatabase());
	}

	public Node searchRoot(SQLiteDatabase db) {
		String selection = "TYPE = ?";
		String[] selectionArgs = { "0" };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	public Node searchById(long id) {
		return searchById(DatabaseHelper.getInstance().getSQLiteDatabase(), id);
	}

	public Node searchById(SQLiteDatabase db, long id) {
		String selection = android.provider.BaseColumns._ID + " = ?";
		String[] selectionArgs = { String.valueOf(id) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	public Node searchByGuid(SQLiteDatabase db, String guid) {
		String selection = "GUID = ?";
		String[] selectionArgs = { guid };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	private List<Node> search(SQLiteDatabase db, String selection,
			String[] selectionArgs, String orderBy) {
		List<Node> list = new ArrayList<Node>();
		Cursor cursor = null;
		try {
			NodeFactory factory = NodeFactory.getInstance();

			cursor = db.query("Node", new String[] {
					android.provider.BaseColumns._ID, "TYPE", "GUID", "PARENT",
					"NAME", "CHILDREN", "STATUS" }, selection, selectionArgs,
					null, null, orderBy);
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				// TODO Factory
				// Node Node = new Node(
				// cursor.getLong(0),
				// cursor.getString(1),
				// cursor.getString(2),
				// cursor.getLong(3),
				// cursor.getLong(4));
				Node node = factory.create(cursor.getLong(0), cursor.getInt(1),
						cursor.getString(2), cursor.getLong(3),
						cursor.getString(4), cursor.getString(5),
						cursor.getInt(6));
				list.add(node);
				cursor.moveToNext();
			}
		} catch (SQLException e) {
			Debug.d(this, null, e);
			list = null;
		} catch (Exception e) {
			Debug.d(this, null, e);
			list = null;
		} finally {
			if (cursor != null) {
				cursor.close();
				cursor = null;
			}
		}
		return list;
	}

	public boolean isEmpty() {
		List<Node> list = search();
		return list == null || list.size() <= 0;
	}

	public long add(Node node) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return add(db, node);
	}

	private long add(SQLiteDatabase db, Node node) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addNT(node);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long addNT(Node node) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindLong(i++, node.getType());
		stmt.bindString(i++, CommonUtil.nz(node.getGuid()));
		stmt.bindLong(i++, node.getParent());
		stmt.bindString(i++, node.getName());
		stmt.bindString(i++, CommonUtil.nz(node.getChildrenString()));
		stmt.bindLong(i++, Node.getStatusCode(node.getStatus()));
		id = stmt.executeInsert();
		return id;
	}

	public long addChildrenId(Node node, long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return addChildrenId(db, node, id);
	}

	private long addChildrenId(SQLiteDatabase db, Node node, long aid) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addChildrenIdNT(node, aid);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long addChildrenIdNT(Node node, long id) {
		List<Long> l = node.getChildren();
		if (l.contains(id)) {
			return -1;
		}
		l.add(id);
		// node.add(id);
		return updateChildrenNT(node, Node.concatChildren(l));
	}

	public long updateChildrenNT(Node node, String children) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = updateChildrenStmt;
		stmt.bindString(i++, node.getChildrenString());
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	public long remoteChildrenId(Node node, long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return remoteChildrenId(db, node, id);
	}

	private long remoteChildrenId(SQLiteDatabase db, Node node, long aid) {
		long id = -1;
		db.beginTransaction();
		try {
			id = remoteChildrenIdNT(node, aid);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long remoteChildrenIdNT(Node node, long id) {
		List<Long> l = node.getChildren();
		if (!l.contains(id)) {
			return -1;
		}
		l.remove(id);
		// node.add(id);
		return updateChildrenNT(node, Node.concatChildren(l));
	}

	public long updateStatus(Node node, Node.Status status) {
		return updateStatus(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, status);
	}

	public long updateStatus(SQLiteDatabase db, Node node, Node.Status status) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateStatusNT(node, status);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long updateStatusNT(Node node, Node.Status status) {
		long id = -1;
		int i = 1;
		int code = Node.getStatusCode(status);

		SQLiteStatement stmt = updateStatusStmt;
		stmt.bindLong(i++, code);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	public long updateName(Node node, String name) {
		return updateName(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, name);
	}

	public long updateName(SQLiteDatabase db, Node node, String name) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateNameNT(node, name);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long updateNameNT(Node node, String name) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateNameStmt;
		stmt.bindString(i++, name);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	public long updateParent(Node node, long parent) {
		return updateParent(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, parent);
	}

	public long updateParent(SQLiteDatabase db, Node node, long parent) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateParentNT(node, parent);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long updateParentNT(Node node, long parent) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateParentStmt;
		stmt.bindLong(i++, parent);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	public long updateChildren(Node node, String children) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return updateChildren(db, node, children);
	}

	private long updateChildren(SQLiteDatabase db, Node node, String children) {
		long id = -1;
		db.beginTransaction();
		try {
			id = updateChildrenNT(node, children);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long delete(long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return delete(db, id);
	}

	public long delete(SQLiteDatabase db, long did) {
		long id = -1;

		db.beginTransaction();
		try {
			id = deleteNT(did);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long deleteNT(long did) {
		long id = -1; // TODO
		int i = 1;

		SQLiteStatement stmt = deleteIdStmt;
		stmt.bindLong(i++, did);
		stmt.execute();
		return id;
	}

	public long delete() {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return delete(db);
	}

	public long delete(SQLiteDatabase db) {
		long id = -1;

		db.beginTransaction();
		try {
			deleteNT();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
