package com.yuji.ef;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff.Mode;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnLongClickListener;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;

public class IconFrameLayout extends FrameLayout implements OnLongClickListener {
	private EverFolderActivity activity = null;

	private LabelIconView target = null;
	private LabelIconView destTarget = null;
	private LabelIconView selectedTarget = null;
	private List<LabelIconView> labelIconViewList = new ArrayList<LabelIconView>();
	
	private Animation anime;
	private int startX;
	private int startY;
	private int currentX;
	private int currentY;
	private int offsetX;
	private int offsetY;
	private boolean longClickFlg = false;
	private IconScrollView scrollView;
	private Context context = this.getContext();

	public IconFrameLayout(Context context) {
		super(context);
	}

	public IconFrameLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public IconFrameLayout(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	public void setActivity(EverFolderActivity activity) {
		this.activity = activity;
	}
	
	@Override
	protected void onLayout(boolean changed, int left, int top, int right,
			int bottom) {
		super.onLayout(changed, left, top, right, bottom);

		int size = this.getChildCount();
		for (int i = 0; i < size; i++) {
			LabelIconView vv = (LabelIconView) this.getChildAt(i);
			int x2 = vv.getInitX();
			int y2 = vv.getInitY();
			// vv.init(x2, y2);
			vv.layout(x2, y2, x2 + vv.getWidth(), y2 + vv.getHeight());
		}
	}

	public LabelIconView getSelectedTarget() {
		return selectedTarget;
	}
	
	public void addView(LabelIconView child) {
		super.addView(child);
		labelIconViewList.add(child);
	}

//	public void removeView(LabelIconView child) {
//		super.removeView(child);
//		labelIconViewList.remove(child);
//	}

	public void removeAllViews(){
		super.removeAllViews();
		labelIconViewList.clear();
	}
	
	public void moveTop(LabelIconView child){
		this.removeView(child);
		this.addView(child);
	}
	
	private LabelIconView getView(int x, int y, LabelIconView v, List<LabelIconView> list, boolean flag) {
		Rect rect = new Rect();

		if (v != null) {
			if (flag){
				v.getHitRect(rect);		
				if (rect.contains(x, y)) {
					return v;
				}
			}
		}
		for (LabelIconView view : list) {
			if (view != v) {
				view.getHitRect(rect);		
				if (rect.contains(x, y)) {
					
					return view;
				}
			}
		}
		return null;
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		try {
			int x = (int) event.getRawX();
			int y = (int) event.getRawY();

			int dx = scrollView.getLeft();
			int dy = scrollView.getTop();

			x -= dx;
			y -= dy;
			
			int sx = x + scrollView.getScrollX();
			int sy = y + scrollView.getScrollY();
			LabelIconView v = getView(sx, sy, target, labelIconViewList, true);
			LabelIconView obj = (LabelIconView) v;

			//int size = labelIconViewList.size();
			if (target == null) {
				target = obj;
			}
			if (target == null){
				return super.onTouchEvent(event);				
			}

			this.getParent().requestDisallowInterceptTouchEvent(true);			
			
			if (event.getAction() == MotionEvent.ACTION_MOVE) {
				if (!longClickFlg) {
					return super.onTouchEvent(event);
				}
				if (target instanceof StatusIconView){
					return super.onTouchEvent(event);					
				}
				obj = target;
				
				int sh = scrollView.getHeight();
				int lh = this.getHeight();
				int maxY = lh - sh;
				int py = scrollView.getScrollY();
				int sdy = 10;
				int N = 100;
				if (y < N){
					if (py > 0){
						if (py < sdy){
							sdy = py;
						}
						scrollView.smoothScrollTo(0, py - sdy);
						currentY -= sdy;
					}
				}
				else if (sh - y < N){
					if (py < maxY){
						if (maxY - py < sdy){
							sdy = maxY - py;
						}
						scrollView.smoothScrollTo(0, py + sdy);
						currentY += sdy;
					}
				}

				int diffX = offsetX - x;
				int diffY = offsetY - y;

				currentX -= diffX;
				currentY -= diffY;
				// currentX = x;;
				// currentY = y;
				obj.layout(currentX, currentY, currentX + obj.getWidth(),
						currentY + obj.getHeight());

				offsetX = x;
				offsetY = y;

				v = getView(sx, sy, target, labelIconViewList, false);
				if (destTarget == null) {
					if (v != null){
						destTarget = v;
						destTarget.setAlpha(128);
					}
				} else {
					if (v != destTarget){
						destTarget.setAlpha(255);
						destTarget = v;
						if (destTarget != null){
							destTarget.setAlpha(128);
						}
					}
				}
			} else if (event.getAction() == MotionEvent.ACTION_DOWN) {
				//if (obj == target){
				if (obj != null){
					if (obj != target){
						target.clearColorFilter();
						target = obj;
					}
					if (target instanceof StatusIconView){
						StatusIconView siv = (StatusIconView)target;
						LabelIconView rv = siv.getRoot();
						long id = rv.getNodeId();

						activity.execute(id);
						return super.onTouchEvent(event);					
					}
					
					if (selectedTarget != null){
						long id = selectedTarget.getNodeId();

						target.clearColorFilter();
						target = null;
						selectedTarget = target;
						activity.targetSelectedChanged(true);
						
						activity.executeView(id);

						return super.onTouchEvent(event);					
					}
					offsetX = x;
					offsetY = y;
					// TODO
					currentX = obj.getLeft();
					currentY = obj.getTop();
	
					target.setColorFilter(Color.RED, Mode.LIGHTEN);
					selectedTarget = target;
					activity.targetSelectedChanged(true);
					
					scrollView.setScrollable(false);
				}
				else {
					target.clearColorFilter();
					target = null;
					selectedTarget = target;
					activity.targetSelectedChanged(false);
				}
				// return false;
			} else if (event.getAction() == MotionEvent.ACTION_UP) {
				if (!longClickFlg) {
					return super.onTouchEvent(event);
				}
				if (target instanceof StatusIconView){
					return super.onTouchEvent(event);					
				}
				obj = target;

				// obj.setVisibility(View.GONE);
				if (destTarget == null || destTarget instanceof StatusIconView) {
					obj.setAnimation(anime);
					obj.startAnimation(anime);
					// layout.removeView(obj);

					int srcX = target.getInitX();
					int srcY = target.getInitY();
					target.layout(srcX, srcY, srcX + target.getWidth(), srcY
							+ target.getHeight());
					target.setAlpha(255);
				} else {
					long src = target.getNodeId();
					long dst = destTarget.getNodeId();
					activity.execute(src, dst);
					
					// TODO
					target = null;
					destTarget = null;

					// T29171
					selectedTarget = null;
					
					scrollView.setScrollable(true);
					scrollView.requestDisallowInterceptTouchEvent(false);
					scrollView.invalidate();
				}

				longClickFlg = false;
			}
			
			return super.onTouchEvent(event);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}

	@Override
	public boolean onLongClick(View view) {
		if (target == null) {
			return false;
		}
		if (target instanceof StatusIconView){
			return false;
		}
		
		LabelIconView v = (LabelIconView) target;
		v.setAlpha(128);
		v.clearColorFilter();

		moveTop(target);
		
		longClickFlg = true;
		return true;
	}

	public void setScrollView(final IconScrollView scrollView) {
		this.scrollView = scrollView;
		this.setOnLongClickListener(this);
		//this.setLongClickable(true);
		
		anime = AnimationUtils.loadAnimation(context, R.anim.sample);
		anime.setAnimationListener(new AnimationListener() {
			public void onAnimationStart(Animation animation) {
			}

			public void onAnimationRepeat(Animation animation) {
			}

			public void onAnimationEnd(Animation animation) {
				// if (isBt2Click) {
				// bt2.performClick();
				// isBt2Click = false;
				// }
				target = null;
				destTarget = null;
				
				scrollView.setScrollable(true);
				scrollView.requestDisallowInterceptTouchEvent(false);
				scrollView.invalidate();
			}
		});
	}
}
