/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.oauth.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.evernote.client.conn.ApplicationInfo;
import com.evernote.client.conn.mobile.TEvernoteHttpClient;
import com.evernote.client.oauth.EvernoteAuthToken;
import com.evernote.client.oauth.android.AuthenticationResult;
import com.evernote.client.oauth.android.EvernoteOAuthActivity;
import com.evernote.edam.notestore.NoteStore;
import java.io.File;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class EvernoteSession {
    private ApplicationInfo applicationInfo;
    private AuthenticationResult authenticationResult;
    private File tempDir;

    public EvernoteSession(ApplicationInfo applicationInfo, File tempDir) {
        this.applicationInfo = applicationInfo;
        this.tempDir = tempDir;
    }

    public EvernoteSession(ApplicationInfo applicationInfo, AuthenticationResult sessionInfo, File tempDir) {
        this(applicationInfo, tempDir);
        this.authenticationResult = sessionInfo;
    }

    public boolean isLoggedIn() {
        return this.authenticationResult != null;
    }

    public void logOut() {
        this.authenticationResult = null;
    }

    public String getAuthToken() {
        if (this.authenticationResult != null) {
            return this.authenticationResult.getAuthToken();
        }
        return null;
    }

    public NoteStore.Client createNoteStore() throws TTransportException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException();
        }
        TEvernoteHttpClient transport = new TEvernoteHttpClient(this.authenticationResult.getNoteStoreUrl(), this.applicationInfo.getUserAgent(), this.tempDir);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new NoteStore.Client((TProtocol)protocol, (TProtocol)protocol);
    }

    public void authenticate(Context context) {
        Intent intent = new Intent(context, EvernoteOAuthActivity.class);
        intent.putExtra("EVERNOTE_HOST", this.applicationInfo.getEvernoteHost());
        intent.putExtra("CONSUMER_KEY", this.applicationInfo.getConsumerKey());
        intent.putExtra("CONSUMER_SECRET", this.applicationInfo.getConsumerSecret());
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public boolean completeAuthentication() {
        if (EvernoteOAuthActivity.authToken != null) {
            EvernoteAuthToken token = EvernoteOAuthActivity.authToken;
            this.authenticationResult = new AuthenticationResult(token.getToken(), token.getNoteStoreUrl(), token.getWebApiUrlPrefix(), token.getUserId());
            return true;
        }
        boolean result = !EvernoteOAuthActivity.startedAuthentication;
        return result;
    }
}

