package com.yuji.ef.dao;

public class NodeFactory {
	private static NodeFactory instance = null;

	public static NodeFactory getInstance(){
		if (instance == null){
			instance = new NodeFactory();
		}
		return instance;
	}	
	
	private NodeFactory(){

	}

	public Node create(long id, int type, String guid, long parent, String name, String children, int status){
		Node node = null;
		
		switch (type){
		case 0:
			// TODO
			node = new RootNode(name, null, children, status);
			break;
		case 1:
			// TODO
			node = new DirNode(name, null, children, status);
			break;
		case 2:
			// TODO
			node = new FileNode(name, null);
			break;
		default:
			break;
		}
		if (node != null){
			node.setId(id);
			node.setParent(parent);
			node.setGuid(guid);
		}
		
		return node;
	}
}
