package com.yuji.ef.dao;

import java.util.List;

import com.yuji.ef.LabelIconView;

public class Node {
	public enum Status {
		NONE, OPEN, CLOSE
	};

	private long id;
	// private Node parent = null;
	private long parent = -1;
	protected String guid = null;
	protected String name = null;
	protected LabelIconView view = null;
	protected List<Long> children = null;

	public static int getStatusCode(Status status) {
		if (status == status.OPEN){
			return 1;
		}
		if (status == status.CLOSE){
			return 2;
		}
		return 0;
	}

	public static Status getStatus(int code){
		switch (code){
		case 1:
			return Status.OPEN;
		case 2:
			return Status.CLOSE;
		}
		return Status.NONE;
	}
	
	public Node(String name, LabelIconView view) {
		this.name = name;
		this.view = view;

		if (view != null) {
			view.setNodeId(this.getId());
		}
	}

	public int getType() {
		return -1;
	}

	public void setView(LabelIconView view) {
		this.view = view;
		if (view != null) {
			view.setNodeId(this.getId());
		}
	}

	public long getId() {
		return id;
	}

	public long getParent() {
		return parent;
	}

	public void setId(long id) {
		this.id = id;
	}

	public void setGuid(String guid) {
		this.guid = guid;
	}

	public void setParent(long parent) {
		this.parent = parent;
	}

	public List<Long> getChildren() {
		return children;
	}

	public String getGuid() {
		return guid;
	}

	public String getName() {
		return name;
	}

	public void add(long node) {
		if (children == null){
			return;
		}
		children.add(node);
		// TODO DB
		// node.setParent(id);
	}

	public void remove(long node) {
		if (children == null){
			return;
		}
		children.remove(node);
		// TODO DB
		// node.setParent(-1);
	}

	public LabelIconView getView() {
		return view;
	}

	public int getIconId() {
		return -1;
	}

	public Status getStatus() {
		return Status.NONE;
	}

	public void setStatus(Status status) {

	}

	public void toggleStatus() {

	}

	public int getStatusIconId() {
		return -1;
	}

	public String getChildrenString() {
		if (children == null || children.size() <= 0) {
			return "";
		}
		return concatChildren(children);
	}
	
	public static String concatChildren(List<Long> children){
		StringBuffer sb = new StringBuffer();
		for (long id : children) {
			if (sb.length() > 0) {
				sb.append(NodeDao.DELM);
			}
			sb.append(String.valueOf(id));
		}
		return sb.toString();		
	}
}
