package jp.co.cqpub.ARView;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import android.hardware.Camera;
import android.hardware.Camera.Size;

public class Reflect {
    private static Method mReflect_getSupportedPreviewSizes;

    static {
        initCompatibility();
    };

    private static void initCompatibility() {
        try {
        	mReflect_getSupportedPreviewSizes = Camera.Parameters.class.getMethod(
	                   "getSupportedPreviewSizes", new Class[] {} );
        } catch (NoSuchMethodException nsme) {
        	mReflect_getSupportedPreviewSizes = null;
        }
    }

    @SuppressWarnings("unchecked")
	static List<Size> getSupportedPreviewSizes(Camera.Parameters p) throws IOException {
	       try {
	    	   if (mReflect_getSupportedPreviewSizes != null) { 
	    		   return (List<Size>)mReflect_getSupportedPreviewSizes.invoke(p);
	    	   }else{
	    		   return null;
	    	   }
	       } catch (InvocationTargetException ite) {
	           /* unpack original exception when possible */
	           Throwable cause = ite.getCause();
	           if (cause instanceof IOException ) {
	               throw (IOException) cause;
	           } else if (cause instanceof RuntimeException) {
	               throw (RuntimeException) cause;
	           } else if (cause instanceof Error) {
	               throw (Error) cause;
	           } else {
	               /* unexpected checked exception; wrap and re-throw */
	               throw new RuntimeException(ite);
	           }
	       } catch (IllegalAccessException ie) {
	           System.err.println("unexpected " + ie);
	   		   return null;
	       }
	   }
}
