/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.foldermenu;

import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.events.IProjectEventListener.PROJECT_CHANGE_TYPE.*;
import org.omegat.plugin.foldermenu.filepreview.FilePreview;

/**
 * easy access to project folders from menu
 *
 * @author Yu Tang
 */
public class FolderMenu implements IApplicationEventListener, IProjectEventListener {

    private MenuManager menuManager;
    
    @SuppressWarnings("LeakingThisInConstructor")
    public FolderMenu() {
        CoreEvents.registerApplicationEventListener(this);
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public void onApplicationStartup() {
        menuManager = new MenuManager();
        FilePreview.init();
    }

    @Override
    public void onApplicationShutdown() { /* do nothing */ }

    @Override
    public void onProjectChanged(PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
        case CREATE:
        case LOAD:
            menuManager.createProjectItems();
            break;
        case CLOSE:
            menuManager.removeAllProjectItems();
            break;
        }
    }

}