/**************************************************************************
 UIFontChanger - Allow to change UI font for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.uifontchanger;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

/**
 * Manage localization.
 * 
 * @author Yu Tang
 */
public class L10n {
    
    public enum Key {
        // for font
        UI_DEFAULT_FONT
    }
    
    private static final ResourceBundle bundle;
    
    static {
        bundle = ResourceBundle.getBundle(L10n.class.getPackage().getName() + ".Bundle");
    }

    public static String get(Key key) {
        if (key == Key.UI_DEFAULT_FONT) {
            return getUIDefaultFontName();
        } else {
            return bundle.getString(key.name());
        }
    }

    private static String getUIDefaultFontName() {
        final List<String> availableFonts = Arrays.asList(StaticUtils.getFontNames());
        String fontName;

        // まずプラットフォーム別のフォント一覧を取得する
        switch (Platform.getOsType()) {
            case MAC32:
            case MAC64:
                fontName = bundle.getString("UI_DEFAULT_FONT_MAC");
                break;
            case WIN32:
            case WIN64:
                fontName = bundle.getString("UI_DEFAULT_FONT_WIN");
                break;
            default:  // Linux and others
                fontName = bundle.getString("UI_DEFAULT_FONT_OTH");
                break;
        }

        // 取得したストリングは、カンマ区切りになっている。
        // fontName1, fontName2, ...
        // 正規表現でフォント名を分割し、実行環境に存在するかチェックする。
        // 最初に見つかった存在するフォント名を返す。
        String src = fontName;
        String[] splitted = fontName.split("\\s*,\\s*");
        for (String s: splitted) {
            if (!s.trim().isEmpty() && availableFonts.contains(s)) {
                return s;
            }
        }
        return null;
    }
}
