/**************************************************************************
 Stats2Excel - open Statistics with Excel from standard Tools menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Log;

/**
 *
 * @author Yu Tang
 */
public class StatsController implements IApplicationEventListener, ActionListener {

    private static final StatsController instance;
    
    private static SplashStatisticsWindow window;

    static {
        instance = new StatsController();
    }
    
    public static StatsController getInstance() {
        return instance;
    }

    private StatsController() { /* singleton */ }

    @Override
    public void onApplicationStartup() {
        if (ExcelModel.getInstalledExcelVersion() != ExcelModel.INSTALLED_VERSION_NOT_FOUND) {
            MenuHandler.HookStatisticsMenu(this);
        }
    }

    @Override
    public void onApplicationShutdown() {
        ExcelModel.close();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        // Item what perform event.
        JMenuItem menuItem = (JMenuItem) e.getSource();

        // Get item name from actionCommand.
        String action = menuItem.getActionCommand();

        Log.logInfoRB("LOG_MENU_CLICK", action);

        window = new SplashStatisticsWindow(
                SplashStatisticsWindow.STAT_TYPE.STANDARD);

        window.setVisible(true);
    }

}
