/**************************************************************************
 Stats2Excel - open Statistics with Excel from standard Tools menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.omegat.core.Core;

/**
 *
 * @author Yu Tang
 */
public class MenuHandler {
    
    private static JMenuItem menuStats = null; 
    private static ActionListener oldListener = null;

    public static void HookStatisticsMenu(ActionListener newListener) {
        if ((menuStats = getStatisticsMenu()) != null) {
            ActionListener[] listeners = menuStats.getActionListeners();
            if (listeners.length > 0) {
                oldListener = listeners[0];
                menuStats.removeActionListener(oldListener);
            }
            menuStats.addActionListener(newListener);
        }
    }

    public static void UnhookStatisticsMenu() {
        if (menuStats != null && oldListener != null) {
            ActionListener[] listeners = menuStats.getActionListeners();
            if (listeners.length > 0) {
                menuStats.removeActionListener(listeners[0]);
            }
            menuStats.addActionListener(oldListener);
            oldListener = null;
        }
    }

    private static JMenuItem getStatisticsMenu() {
        JMenu toolsMenu = Core.getMainWindow().getMainMenu().getToolsMenu();
        Component[] menuComponents = toolsMenu.getMenuComponents();
        for (Component c : menuComponents) {
            if (c instanceof JMenuItem) {
                JMenuItem m = (JMenuItem) c;
                if ("toolsShowStatisticsStandardMenuItem".equals(m.getActionCommand())) {
                    return m;
                }
            }
        }
        return null;
    }
    
}