/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.util.ResourceBundle;

/**
 * Manage localization.
 * 
 * @author Yu Tang
 */
public class L10n {
    
    public enum Key {
        // for menu
        MOENIZER_MENU_LABEL,
        MOENIZER_MENU_TOOLTIP,

        // settings dialog
        DIALOG_TITLE,

        // for error
        ERROR_FILE_HAS_NO_ASSOC,
        
        // version
        CURRENT_VERSION
    }
    
    private static final ResourceBundle bundle;
    
    static {
        bundle = ResourceBundle.getBundle(L10n.class.getPackage().getName() + ".Bundle");
    }

    public static String get(Key key) {
        return bundle.getString(key.name());
    }

}
