/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2015 Yu Tang
               Home page: http://osdn.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.osdn.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.osdn.users.yutang.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

/**
 * direct access to the relevant folders/files via menu
 *
 * @author Yu Tang
 */
public class FolderMenuListener implements MenuListener {

    public FolderMenuListener() {
        FilePreview.init();                      //@@TODO remove this
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu menu = (JMenu) e.getSource();
        String action = menu.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", action);

        buildSubmenus(menu);
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        destruct((JMenu) e.getSource());
    }

    @Override
    public void menuCanceled(MenuEvent e) {
        destruct((JMenu) e.getSource());
    }

    private void destruct(JMenu menu) {
        menu.removeAll();
    }

    private void buildSubmenus(JMenu parent) {
        parent.add(createProjectRootMenu());
        parent.add(createUserConfigMenu());
        parent.add(createApplicationRootMenu());
        parent.add(new JSeparator());
        parent.add(createCurrentSourceDocumentMenuItem());
        parent.add(createCurrentTargetDocumentMenuItem());
    }

    private JMenuItem createProjectRootMenu() {
        final String LABEL_TEXT = L10n.Entry.PROJECT_ROOT_MENU_LABEL.toString();
        IProject project = Core.getProject();
        String path = "";

        if (project.isProjectLoaded()) {
            path = project.getProjectProperties().getProjectRoot();
        }
        return MenuFactory.createMenuItem(path, LABEL_TEXT);
    }

    private JMenuItem createUserConfigMenu() {
        final String LABEL_TEXT =L10n.Entry.USER_CONFIG_MENU_LABEL.toString();
        String path = StaticUtils.getConfigDir();
        return MenuFactory.createMenuItem(path, LABEL_TEXT);
    }

    private JMenuItem createApplicationRootMenu() {
        final String LABEL_TEXT = L10n.Entry.APPLICATION_ROOT_MENU_LABEL.toString();
        String path = StaticUtils.installDir();
        return MenuFactory.createMenuItem(path, LABEL_TEXT);
    }

    private JMenuItem createCurrentSourceDocumentMenuItem() {
        IProject project = Core.getProject();
        String currentFile = "";
        final String LABEL_TEXT = L10n.Entry.SOURCE_DOC_MENU_LABEL.toString();

        if (project.isProjectLoaded()) {
            // relative path to the root of Source directory 
            currentFile = Core.getEditor().getCurrentFile();
            if (!StringUtil.isEmpty(currentFile)) {
                String sourceRoot = project.getProjectProperties().getSourceRoot();
                currentFile = sourceRoot + currentFile;
            }
        }
        return MenuFactory.createMenuItem(currentFile, LABEL_TEXT);
    }

    private JMenuItem createCurrentTargetDocumentMenuItem() {
        IProject project = Core.getProject();
        final String LABEL_TEXT = L10n.Entry.TARGET_DOC_MENU_LABEL.toString();
        File translatedFile = new File("");

        if (project.isProjectLoaded()) {
            // relative path to the root of Source directory 
            String currentFile = Core.getEditor().getCurrentFile();
            if (currentFile != null) {
                translatedFile = FilterHelper.getTargetFile(currentFile);
            }
        }

        return MenuFactory.createMenuItem(translatedFile, LABEL_TEXT);
    }
}
