/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2015 Yu Tang
               Home page: http://osdn.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.osdn.users.yutang.omegat.plugin.foldermenu;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.Core;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.openide.awt.Mnemonics;

/**
 * easy access to project folders from menu
 *
 * @author Yu Tang
 */
public class FolderMenu implements IApplicationEventListener {

    private static boolean initialized = false;

    public static void loadPlugins() {
        try {
            // Not initialize in console mode
            if (initialized) {
                throw new RuntimeException("FolderMenu plugin could be instantiated only once.");
            } else if (Platform.isWebStart()) {
                // Just log it, no error.
                Log.log("FolderMenu plugin is not available with Java Web Start.");
            } else {
                CoreEvents.registerApplicationEventListener(new FolderMenu());
            }
        } catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB("LD_ERROR", msg);
            Core.pluginLoadingError(msg);
        } finally {
            initialized = true;
        }
   }

    public static void unloadPlugins() {
        // do nothing
    }

    @Override
    public void onApplicationStartup() {
        // insert Files menu before the last menu (Help menu.)
        JMenu menu = createFolderMenu();
        JMenuBar mainMenuBar = (JMenuBar) Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add(menu, mainMenuBar.getMenuCount() - 1);

        // remove ApplicationEventListener
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                CoreEvents.unregisterApplicationEventListener(FolderMenu.this);
            }
        });
    }

    private static JMenu createFolderMenu() {
        JMenu menu = new JMenu();
        menu.setActionCommand("foldersMenu");
        String labelString = L10n.Entry.FOLDERS_MENU_LABEL.toString();
        Mnemonics.setLocalizedText(menu, labelString);
        menu.addMenuListener(new FolderMenuListener());
        return menu;
    }

    @Override
    public void onApplicationShutdown() { /* do nothing */ }
}