/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JMenu;
import static jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper.getComparator;
import static jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper.getFilteredListFiles;
import static jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper.getMenuListener;
import static jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper.getMouseListener;
import org.omegat.util.Log;
import org.openide.awt.Mnemonics;

/**
 *
 * @author Yu Tang
 */
public class ShellLinkMenu extends JMenu {

    @SuppressWarnings("LeakingThisInConstructor")
    public ShellLinkMenu(File folder, String label) throws IOException {
        this(folder);
        Mnemonics.setLocalizedText(this, label);
    }

    public ShellLinkMenu(File folder) throws IOException {
        super(folder.getName());

        addMenuListener(getMenuListener());
        addMouseListener(getMouseListener());

        setIcon(MenuHelper.getIcon(folder));
        setActionCommand(folder.getCanonicalPath());
    }

    @SuppressWarnings("LeakingThisInConstructor")
    public ShellLinkMenu(String label) throws IOException {
        super();
        Mnemonics.setLocalizedText(this, label);

        addMenuListener(getMenuListener());
        addMouseListener(getMouseListener());
 
        setEnabled(false);
    }

    public void createChildren() {
        if (isEnabled() && getItemCount() == 0) {
            File folder = new File(getActionCommand());
            File[] filteredListFiles = getFilteredListFiles(folder);
            Arrays.sort(filteredListFiles, getComparator());

            for (File file : filteredListFiles) {
                try {
                    if (file.isDirectory() && hasChildren(file)) {
                        add(new ShellLinkMenu(file));
                    } else {
                        add(new ShellLinkMenuItem(file));
                    }
                } catch (IOException ex) {
                    Log.log(ex);
                }
            }
        }
    }
    
    public JMenu getMenu() {
        return (JMenu) this;
    }

    public void link(File folder) throws IOException {
        setActionCommand(folder.getCanonicalPath());
        setIcon(MenuHelper.getIcon(folder));
        setEnabled(true);
    }

    public void unlink() {
        setEnabled(false);
        removeAll();
        setActionCommand("");
        setIcon(null);
    }

    private boolean hasChildren(File folder) {
        return getFilteredListFiles(folder).length > 0;
    }

}
