/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.core.Core;
import org.omegat.util.Log;

/**
 * easy access to project folders from menu
 *
 * @author Yu Tang
 */
public class FolderMenu implements IApplicationEventListener, IProjectEventListener {

    private static boolean instantiated = false;

    private MenuManager menuManager;
    
    public static void loadPlugins() {
        try {
            // Not initialize in console mode
            if (instantiated) {
                throw new RuntimeException("FolderMenu plugin could be instantiated only once.");
            } else if (isRunningJavaWebStart()) {
                // Just log it, no error.
                Log.log("FolderMenu plugin is not working with Java Web Start.");
            } else {
                CoreEvents.registerApplicationEventListener(new FolderMenu());
            }
        } catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB("LD_ERROR", msg);
            Core.pluginLoadingError(msg);
        }
   }

    private FolderMenu() {
        FolderMenu.instantiated = true;
    }
    
    public static void unloadPlugins() {
        // do nothing
    }

    @Override
    public void onApplicationStartup() {
        menuManager = new MenuManager();
        MenuHelper.setMenuManager(menuManager);
        FilePreview.init();
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public void onApplicationShutdown() { /* do nothing */ }

    @Override
    public void onProjectChanged(PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
        case CREATE:
        case LOAD:
            menuManager.createProjectItems();
            break;
        case CLOSE:
            menuManager.removeAllProjectItems();
            menuManager.unlinkCurrentSourceFile();
            break;
        }
    }

    private static boolean isRunningJavaWebStart() {
        boolean hasJNLP = false;
        try {
            Class.forName("javax.jnlp.ServiceManager");
            hasJNLP = true;
        } catch (ClassNotFoundException ex) {
            // ignore
        }
        return hasJNLP;
    }

}