/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.moenizer;

import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.ui.DockViewTitleBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

/**
 *
 * @author Yu-Tang
 */
public class MoeDockViewTitleBarUI extends DockViewTitleBarUI {
  
    /* hack to use custom painting except on mac os (ugly opacity effects)  */
    private static boolean useCustomPaint = System.getProperty("os.name").
        toLowerCase().indexOf("mac os") < 0;
    
    /* Alpha value for transparency (0-255) */
    private static int activeAlpha   = 150; // transparent 0 <- ... -> 255 opaque
    private static int inactiveAlpha = 100; // transparent 0 <- ... -> 255 opaque
  
    private Color activePanelColor = MoeDockViewTitleBarUI.makeTranslucentColor(
            UIManager.getColor("Panel.background"), activeAlpha);
    private Color inactivePanelColor = MoeDockViewTitleBarUI.makeTranslucentColor(
            UIManager.getColor("Panel.background"), inactiveAlpha);
    //private Color highlight = makeTranslucent(UIManager.getColor("controlLtHighlight"));
    

    public MoeDockViewTitleBarUI(DockViewTitleBar tb) {
        super(tb);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (MoeDockViewTitleBarUI.useCustomPaint) {
            DockViewTitleBar tb = (DockViewTitleBar)c;

            Graphics2D g2 = (Graphics2D) g.create();
            g2.setColor(tb.isActive() ? activePanelColor : inactivePanelColor);
            g2.fillRect(0, 0, tb.getWidth(), tb.getHeight()); // emptyborder doesnt repaint
            g2.dispose();            
        } else {
            super.paint(g, c);
        }
    }
    
    private static Color makeTranslucentColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
    
}
