/*
 * Configuation settings for HSBRX63NC
 *
 * Copyright (C) 2014 Yoshinori Sato
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __HSBRX63NC_H
#define __HSBRX63NC_H

#define CONFIG_RX		1
#define CONFIG_RX600		1
#define CONFIG_CPU_RX63X	1
#define CONFIG_CPU_RX63N	1

#include <config_cmd_default.h>
#undef CONFIG_CMD_BDI
#undef CONFIG_CMD_FPGA
#undef CONFIG_CMD_IMI
#undef CONFIG_CMD_IMLS
#undef CONFIG_CMD_SETGETDCR
#undef CONFIG_CMD_NET
#undef CONFIG_CMD_NFS

#define CONFIG_BAUDRATE		38400
#define CONFIG_BOOTARGS		"console=ttySC2,38400"
#define CONFIG_BOARD_LATE_INIT

#define CONFIG_VERSION_VARIABLE
#undef  CONFIG_SHOW_BOOT_PROGRESS

/* system */
#define CONFIG_SYS_TEXT_BASE	0xfffe0000
#define CONFIG_SYS_LONGHELP		/* undef to save memory	*/
#define CONFIG_SYS_PROMPT	"=> "	/* Monitor Command Prompt */
#define CONFIG_SYS_CBSIZE	256	/* Buffer size for input from the Console */
#define CONFIG_SYS_PBSIZE	256	/* Buffer size for Console output */
#define CONFIG_SYS_MAXARGS	16	/* max args accepted for monitor commands */
/* List of legal baudrate settings for this board */
#define CONFIG_SYS_BAUDRATE_TABLE	{ 9600,14400,19200,38400,57600,115200 }

#define CONFIG_ENV_IS_IN_FLASH
#define CONFIG_ENV_SIZE 2048
#define CONFIG_ENV_ADDR 0x100000

/* SCI */
#define CONFIG_SCI		1
#define CONFIG_SCIF_CONSOLE	1
#define CONFIG_CONS_SCIF2	1

/* memory */
#define CONFIG_SYS_SRAM_BASE		0x00008000
#define CONFIG_SYS_SRAM_SIZE		0x00018000
#define CONFIG_SYS_SDRAM_BASE		0x08000000
#define CONFIG_SYS_SDRAM_SIZE		(32 * 1024 * 1024)
#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE
#define CONFIG_SYS_MEMTEST_END		CONFIG_SYS_SDRAM_SIZE

#define CONFIG_SYS_LOAD_ADDR		(CONFIG_SYS_MEMTEST_START)
#define CONFIG_SYS_MONITOR_BASE		(CONFIG_SYS_TEXT_BASE)
#define CONFIG_SYS_MONITOR_LEN		(256 * 1024)
#define CONFIG_SYS_MALLOC_LEN		(256 * 1024)
#define CONFIG_SYS_GBL_DATA_SIZE	256
#define CONFIG_SYS_BOOTMAPSZ		(8 * 1024 * 1024)
#define CONFIG_SYS_MAX_FLASH_SECT	16
#define CONFIG_SYS_MAX_FLASH_BANKS	1
#define CONFIG_SYS_FLASH_PROTECTION

#define CONFIG_SYS_CLK_FREQ 48000000
#define CONFIG_SH_SCIF_CLK_FREQ CONFIG_SYS_CLK_FREQ
#define CONFIG_SYS_HZ	1000

#define CONFIG_SYS_TIMER_BASE (0x00088200)

#if defined(CONFIG_CMD_NET)
#define CONFIG_NET_MULTI 1
#define CONFIG_SH_ETHER 1
#define CONFIG_SH_ETHER_USE_PORT (0)
#define CONFIG_SH_ETHER_PHY_ADDR (0x00)
#define CONFIG_SH_ETHER_PHY_MODE PHY_INTERFACE_MODE_RMII
#define CONFIG_MII 1
#define CONFIG_BITBANGMII 1
#define CONFIG_BITBANGMII_MULTI 1
#define CONFIG_PHYLIB 1
#define CONFIG_PHY_SMSC 1
#endif

#if defined(CONFIG_CMD_USB)
#define CONFIG_USB_R8A66597_HCD
#define CONFIG_R8A66597_BASE_ADDR   0x000a0200
#define CONFIG_R8A66597_ENDIAN      0x0000  /* little */
#define CONFIG_SUPERH_ON_CHIP_R8A66597
#define CONFIG_R8A66597_VBUS_NEG
#define CONFIG_USB_STORAGE
#endif

#define CONFIG_USB_GADGET
#define CONFIG_USB_GADGET_R8A66597
#define CONFIG_R8A66597_UDC_BASE	0x000a0000
#define CONFIG_USB_GADGET_SERIAL
#define CONFIG_USB_TTY_CDC

#if defined(CONFIG_CMD_MMC_SPI)
#define CONFIG_RX_RSPI
#define CONFIG_RSPI_BASE	0x00088380
#define CONFIG_RSPI_CLK		CONFIG_SYS_CLK_FREQ
#define CONFIG_MMC
#define CONFIG_MMC_SPI
#define CONFIG_GENERIC_MMC
#endif
#endif	/* __HSBRX63NC_H */
