/*
 * Copyright (C) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <asm/io.h>
#include <spi.h>

#define P6DR  0xffffd5

#define CS (1 << 2)

static 	struct bb_spi_dev *dev;

int spi_cs_is_valid(unsigned int bus, unsigned int cs)
{
	return bus == 0 && cs == 0;
}

void spi_cs_activate(struct spi_slave *slave)
{
	unsigned char d;
	d = readb(P6DR);
	writeb(d | CS, P6DR);
}

void spi_cs_deactivate(struct spi_slave *slave)
{
	unsigned char d;
	d = readb(P6DR);
	writeb(d & ~CS, P6DR);
}

void spi_set_speed(struct spi_slave *slave, uint max_hz)
{
}

int board_mmc_init(bd_t *bis)
{
	gpio_request(0x0a05, "spi-clk");
	gpio_request(0x0a06, "spi-do");
	gpio_request(0x0a07, "spi-di");
	gpio_request(0x0502, "spi-cs");
	gpio_direction_output(0x0502, 0);
	gpio_direction_output(0x0a05, 0);
	gpio_direction_output(0x0a06, 0);
	gpio_direction_input(0x0a07, 0);
	return 0;
}
