/*
 * Copyright (C) 2010 Yoshinori Sato <ysato@users.sourceforge.jp>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

	.h8300h

	.section	".vector","ax"
	.global	_start
	.global	relocate_code
	.long	_start
vector	=	1
	.rept	63
	.long	_ram_vec + (vector * 4)
vector	=	vector + 1
	.endr

	.text
	.align	2
_start:
	mov.l	#_init_stack,sp
	jsr	@lowlevel_init

	mov.l	#__bss_start,er4
	mov.l	#__bss_end,er5
	sub	er4,er5
	shlr.l	er5
	shlr.l	er5
	sub.l	er0,er0
1:	mov.l	er0,@er4		/* bss clear */
	adds	#4,er4
	dec.l	#1,er5
	bne	1b
	mov.l	#_ram_vec,sp
	sub.l	er0,er0			/* boot flags */
	jsr	@board_init_f
	bra	.

relocate_code:
	mov.l	er1,er0
	sub.l	er1,er1
	jmp	@board_init_r

	.end
