/*
 * Copyright (c) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <asm/io.h>

static unsigned int last = 0x00ffffff;
static unsigned long long ticks = 0;

int timer_init(void)
{
	writel(0x00ffffff, 0xe000e014);
	writel(0x00000005, 0xe000e010);
	return 0;
}

unsigned long long get_ticks(void)
{
	unsigned int cur = readl(0xe000e018);
	unsigned int delta = last - cur;
	last = cur;
	if (readl(0xe000e010) & (1 << 16))
		delta += 0x01000000;
	ticks += delta;
	return ticks;
}

unsigned long get_tbclk(void)
{
	return CONFIG_SYS_CLK_FREQ;
}

void __udelay(unsigned long usec)
{
	unsigned long long end = get_ticks() + CONFIG_SYS_CLK_FREQ / 1000000;
	while(get_ticks() < end);
}
