/*
 * (C) Copyright 2003
 * Texas Instruments.
 * Kshitij Gupta <kshitij@ti.com>
 * Configuation settings for the TI OMAP Innovator board.
 *
 * (C) Copyright 2004
 * ARM Ltd.
 * Philippe Robin, <philippe.robin@arm.com>
 * Configuration for Versatile PB.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_ARMV7M	1
#define CONFIG_CPU_FM3
#define CONFIG_CQ_FRK_FM3	1
#define CONFIG_SYS_THUMB_BUILD
#define CONFIG_USE_PRIVATE_LIBGCC

#define CONFIG_SYS_TEXT_BASE		0x00000000
#define CONFIG_SYS_MEMTEST_START	0x62000000
#define CONFIG_SYS_MEMTEST_END		0x62400000

#define CONFIG_SYS_TIMER_NVIC

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs */
#define CONFIG_SETUP_MEMORY_TAGS	1

#define CONFIG_ENV_IS_IN_FLASH
#define CONFIG_ENV_SIZE			8192
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 256 * 1024)

#define CONFIG_SYS_CLK_FREQ		144000000
#define CONFIG_APB2_CLK_FREQ		36000000
#define CONFIG_FM3_SERIAL
#define CONFIG_SYS_FM3_UART_CH		4
#define CONFIG_CONS_INDEX	0
#define CONFIG_BAUDRATE			115200
/*
 */
#define CONFIG_CMD_BDI
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_SAVEENV
#define CONFIG_CMD_FLASH
#define CONFIG_CMD_LOADS
#define CONFIG_CMD_NET
#define CONFIG_CMD_MMC
#define CONFIG_CMD_MMC_SPI
#define CONFIG_CMD_FAT
#define CONFIG_CMD_EXT2
#define CONFIG_CMD_PART
#define CONFIG_CMD_USB
#define CONFIG_CMD_MISC
#define CONFIG_CMD_CONSOLE

#define CONFIG_DOS_PARTITION
#define CONFIG_PARTITION_UUIDS
#define CONFIG_NET_MULTI
#define CONFIG_SYS_CONSOLE_IS_IN_ENV
#define CONFIG_CONSOLE_MUX
#define CONFIG_USB_STORAGE
#define CONFIG_BOARD_LATE_INIT

/*
 * Miscellaneous configurable options
 */
#define CONFIG_SYS_LONGHELP	/* undef to save memory */
#define CONFIG_SYS_CBSIZE	256		/* Console I/O Buffer Size */
/* Monitor Command Prompt	 */
#define CONFIG_SYS_PROMPT	"=> "

/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE	\
			(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS	16		/* max number of command args */
#define CONFIG_SYS_BARGSIZE	CONFIG_SYS_CBSIZE /* Boot Argument Buffer Size */

#define CONFIG_SYS_LOAD_ADDR	0x60100000	/* default load address */

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS	1	/* we have 1 bank of DRAM */
#define PHYS_SDRAM_1		0x62000000	/* SDRAM Bank #1 */
#define PHYS_SDRAM_1_SIZE	0x00400000	/* 4MB */
#define PHYS_FLASH_SIZE		0x00100000	/* 1MB */

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM_1
#define CONFIG_SYS_SDRAM_SIZE		PHYS_SDRAM_1_SIZE
#define CONFIG_SYS_INIT_RAM_ADDR	0x1fff0000
#define CONFIG_SYS_INIT_RAM_SIZE	0x00020000
#define CONFIG_SYS_GBL_DATA_OFFSET	(CONFIG_SYS_INIT_RAM_SIZE - \
						GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR	(CONFIG_SYS_INIT_RAM_ADDR + \
						CONFIG_SYS_GBL_DATA_OFFSET)

#define CONFIG_BOARD_EARLY_INIT_F

#define CONFIG_FM3_FLASH
#define PHYS_FLASH_SIZE			0x00100000
#define FLASH_SECTOR_SIZE		0x00004000
#define CONFIG_ENV_SECT_SIZE		(1 * FLASH_SECTOR_SIZE)
#define CONFIG_SYS_MAX_FLASH_SECT	(14)
#define CONFIG_SYS_MAX_FLASH_BANKS	3
#define CONFIG_SYS_FLASH_SIZE		PHYS_FLASH_SIZE

#define CONFIG_SYS_FLASH_BASE		0x00000000

#define CONFIG_SYS_MONITOR_LEN		(4 * CONFIG_ENV_SECT_SIZE)

#define FLASH_TOP			(CONFIG_SYS_FLASH_BASE + PHYS_FLASH_SIZE)
#define CONFIG_ENV_ADDR			0x00004000
#define CONFIG_ENV_OFFSET		(CONFIG_ENV_ADDR - CONFIG_SYS_FLASH_BASE)
#define CONFIG_SYS_MONITOR_BASE		(CONFIG_ENV_ADDR - CONFIG_SYS_MONITOR_LEN)

#ifdef CONFIG_CMD_NET
#define CONFIG_FM3_ETHER
#define CONFIG_FM3_PHY_ADDR		{16, 16}
#define CONFIG_FM3_MAC_CH		0
#define CONFIG_MII
#define CONFIG_PHYLIB
#define CONFIG_PHY_IDT
#endif

#ifdef CONFIG_CMD_MMC_SPI
#define CONFIG_MMC
#define CONFIG_MMC_SPI
#define CONFIG_GENERIC_MMC
#define CONFIG_FM3_MFS_SPI
#define CONFIG_FM3_SPI_CH		6
#endif

#ifdef CONFIG_CMD_USB
#define CONFIG_USB_MB9BFXXX
#define CONFIG_FM3_USB_HOST		0x40052100
#endif
#define CONFIG_FM3_UDC			0x40042100
#define CONFIG_USB_GADGET
#define CONFIG_USB_GADGET_SERIAL
#define CONFIG_USB_TTY_CDC

#endif	/* __CONFIG_H */
