/*
 * FM3 GPIO driver
 * Copyright (C) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 */

#include <common.h>
#include <asm/io.h>
#include <errno.h>

#define GPIO_PFR	0x40033000
#define GPIO_PCR	0x40033100
#define GPIO_DDR	0x40033200
#define GPIO_PDIR	0x40033300
#define GPIO_PDOR	0x40033400

int gpio_request(unsigned gpio, const char *label)
{
	int port = (gpio >> 8) & 0x0f;
	int pin = gpio & 0x0f;

	if (readl(GPIO_PFR + port) & (1 << pin))
		return -EBUSY;
	else
		return 0;
}

int gpio_free(unsigned gpio)
{
	return 0;
}

int gpio_direction_input(unsigned gpio)
{
	int port = ((gpio >> 8) & 0x0f) * 4;
	int pin = gpio & 0x0f;
	writew(readw(GPIO_DDR + port) & ~(1 << pin), GPIO_DDR + port);
	return 0;
}

int gpio_direction_output(unsigned gpio, int value)
{
	int port = ((gpio >> 8) & 0x0f) * 4;
	int pin = gpio & 0x0f;
	writew(readw(GPIO_DDR + port) | (1 << pin), GPIO_DDR + port);
	return 0;
}

void gpio_set_value(unsigned gpio, int value)
{
	int port = ((gpio >> 8) & 0x0f) * 4;
	int pin = gpio & 0x0f;
	unsigned short v = readw(GPIO_PDOR + port);
	if (value)
		v |= 1 << pin;
	else
		v &= ~(1 << pin);
	writew(v, GPIO_PDOR + port);
}

int gpio_get_value(unsigned gpio)
{
	int port = ((gpio >> 8) & 0x0f) * 4;
	int pin = gpio & 0x0f;
	return (readw(GPIO_PDOR + 0x02000000 + port) >> pin) & 1;
}
