/*
 * Copyright 2010 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <net.h>
#include <netdev.h>
#include <asm/io.h>
#include <asm/processor.h>
#include <asm/gpio.h>

int checkboard(void)
{
	puts("BOARD: nisshin-tech KaneBebe\n");
	return 0;
}

int board_init(void)
{
	h8300_gpio_init();
	return 0;
}

int dram_init(void)
{
	DECLARE_GLOBAL_DATA_PTR;

	gd->bd->bi_memstart = CONFIG_SYS_DRAM_BASE;
	gd->bd->bi_memsize = CONFIG_SYS_DRAM_SIZE;
	printf("DRAM:  %dMB\n", CONFIG_SYS_DRAM_SIZE / (1024 * 1024));
	return 0;
}

#ifdef CONFIG_CMD_NET
int board_eth_init(bd_t *bis)
{
	int ret = 0;
#ifdef CONFIG_DRIVER_NE2000
	ret = ne2k_register();
#endif
#ifdef CONFIG_USB_GADGET_N9604
	n9604_udc_probe();
#ifdef CONFIG_USB_ETHER
	usb_eth_initialize(bis);
#endif
#endif
	return ret;
}
#endif

int board_late_init(void)
{
	DECLARE_GLOBAL_DATA_PTR;

#ifdef CONFIG_CMD_MMC
	mmc_initialize(gd->bd);
#endif
#ifdef CONFIG_CMD_LED
	__led_init(STATUS_LED_BIT, 0);
	__led_init(STATUS_LED_BIT1, 0);
#endif

	return 0;
}
