#define FACICMD		0x007e0000
#define FASTAT		0x007fe010
#define FSADDR		0x007fe030
#define FCURAME		0x007fe054
#define FSTATR		0x007fe080
#define FENTRYR		0x007fe084
#define FPROTR		0x007fe088
#define FLKSTAT		0x007fe090
#define FPCKAR		0x007fe0e4
#define FWEPROR		0x0008c296

#define FASTAT_CMDLK	(1 << 4)

#define FCURAME_KEY	0xc400
#define FCURAME_FCRME	0x03

#define FSTATR0_ILGLERR	(1 << 6)

#define FPROTR_KEY	0x5500
#define FPROTR_FPROTCN	0x0001

#define FENTRYR_KEY	0xaa00
#define FENTRYR_FENTRYD	0x80

#define FPCKAR_KEY	0x1e

#define FCU_PROG	0xe8
#define FCU_PROG_DONE	0xd0

#define FCU_STATCLR	0x50

#define FCURAM_TOP	0x007f8000
#define FCUFIRM_TOP	0xfefff000
#define FCUFIRM_SIZE	0x1000

#define ABORT		0xb3
#define FRDY		(1<<15)
#define DBFULL		(1<<10)

/* call for forced to JSR */
int (*rx_flash_wait_frdy)(void);
int (*rx_flash_pe_mode)(unsigned int);
void (*rx_flash_normal_mode)(void);
int (*rx_flash_write_c)(uchar *, ulong, ulong);
int (*rx_flash_protect_c)(unsigned long, int);
int (*rx_flash_erase_page_c)(unsigned int);
void (*rx_flash_abort)(void);
void (*rx_fcu_init)(void);
