/*
 * RX gdb server stub
 *
 * Copyright (c) 2018 Yoshinori Sato
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include "qemu/osdep.h"
#include "qemu-common.h"
#include "cpu.h"
#include "exec/gdbstub.h"

/* Hint: Use "set architecture sh4" in GDB to see fpu registers */
/* FIXME: We should use XML for this.  */

int rx_cpu_gdb_read_register(CPUState *cs, uint8_t *mem_buf, int n)
{
    RXCPU *cpu = RXCPU(cs);
    CPURXState *env = &cpu->env;

    switch (n) {
    case 0 ... 15:
        return gdb_get_regl(mem_buf, env->regs[n]);
    case 16:
        return gdb_get_regl(mem_buf, env->usp);
    case 17:
        return gdb_get_regl(mem_buf, env->isp);
    case 18:
        return gdb_get_regl(mem_buf, cpu_read_psw(env));
    case 19:
        return gdb_get_regl(mem_buf, env->pc);
    case 20:
        return gdb_get_regl(mem_buf, env->intb);
    case 21:
        return gdb_get_regl(mem_buf, env->bpsw);
    case 22:
        return gdb_get_regl(mem_buf, env->bpc);
    case 23:
        return gdb_get_regl(mem_buf, env->fintv);
    case 24:
        return gdb_get_regl(mem_buf, env->fpsw);
    case 25:
        return 0;
    }
    return 0;
}

int rx_cpu_gdb_write_register(CPUState *cs, uint8_t *mem_buf, int n)
{
    RXCPU *cpu = RXCPU(cs);
    CPURXState *env = &cpu->env;

    switch (n) {
    case 0 ... 15:
        env->regs[n] = ldl_p(mem_buf);
        break;
    case 16:
        env->usp = ldl_p(mem_buf);
        break;
    case 17:
        env->isp = ldl_p(mem_buf);
        break;
    case 18:
        cpu_write_psw(env, ldl_p(mem_buf));
        break;
    case 19:
        env->pc = ldl_p(mem_buf);
        break;
    case 20:
        env->intb = ldl_p(mem_buf);
        break;
    case 21:
        env->bpsw = ldl_p(mem_buf);
        break;
    case 22:
        env->bpc = ldl_p(mem_buf);
        break;
    case 23:
        env->fintv = ldl_p(mem_buf);
        break;
    case 24:
        env->fpsw = ldl_p(mem_buf);
        break;
    case 25:
        return 8;
    default:
        return 0;
    }

    return 4;
}
